<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8"/>
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0"/>
  <title>WAF FARMS</title>
  <style>
    body {
      font-family: 'Segoe UI', sans-serif;
      background: #f4f6f9;
      margin: 0;
      padding: 0;
    }

    main {
      padding-bottom: 100px; /* Enough space for bottom menu */
    }

    .top-bar {
      display: flex;
      align-items: center;
      background: linear-gradient(to right, #55b432, #55b432);
      padding: 14px 16px;
      color: #fff;
      font-size: 18px;
      font-weight: bold;
      box-shadow: 0 2px 4px rgba(0,0,0,0.15);
      position: sticky;
      top: 0;
      z-index: 99;
    }

    .back-btn {
      text-decoration: none;
      color: #fff;
      font-size: 20px;
      margin-right: 12px;
    }

    .top-bar .title {
      flex-grow: 1;
      text-align: center;
      margin-right: 32px;
    }

    .tab-buttons {
      display: flex;
      gap: 10px;
      padding: 15px;
      background: #fff;
      position: sticky;
      top: 58px;
      z-index: 90;
      box-shadow: 0 2px 5px rgba(0,0,0,0.04);
    }

    .tab-buttons button {
      flex: 1;
      padding: 10px;
      font-size: 15px;
      border: none;
      border-radius: 8px;
      cursor: pointer;
      background: #ccc;
      color: #fff;
      transition: 0.3s;
    }

    .tab-buttons button.active {
      background: #55b432;
      box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    }

    .product-tab {
      display: none;
      animation: fadeIn 0.3s ease;
    }

    .product-tab.active {
      display: block;
    }

    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(5px); }
      to { opacity: 1; transform: translateY(0); }
    }

    .product-box {
      background: #fff;
      border-radius: 12px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.06);
      margin: 15px;
      overflow: hidden;
      transition: transform 0.2s;
    }

    .product-box:hover {
      transform: scale(1.01);
    }

    .product-box.discount {
      background: #fffce6;
      border: 1px solid #f4c430;
    }

    .product-box.soldout {
      opacity: 0.6;
      pointer-events: none;
    }

    .product-header {
      background: #55b432;
      color: #fff;
      padding: 12px 16px;
      font-weight: bold;
      position: relative;
    }

    .badge {
      background: #ffc107;
      color: #000;
      padding: 3px 7px;
      font-size: 12px;
      border-radius: 4px;
      position: absolute;
      top: 12px;
      right: 16px;
    }

    .product-body {
      padding: 15px;
    }

    .product-content {
      display: flex;
      gap: 12px;
    }

    .product-left img {
      width: 85px;
      height: 85px;
      object-fit: cover;
      border-radius: 8px;
    }

    .product-info {
      flex: 1;
      font-size: 14px;
      color: #333;
    }

    .product-info p {
      margin: 6px 0;
      display: flex;
      justify-content: space-between;
    }

    .product-info span {
      color: #55b432;
      font-weight: 600;
    }

    .product-footer {
      margin-top: 10px;
      display: flex;
      justify-content: space-between;
      flex-wrap: wrap;
      align-items: center;
    }

    .price-discount {
      font-size: 14px;
    }

    .original-price {
      text-decoration: line-through;
      color: #888;
    }

    .discounted-price {
      color: red;
      font-weight: bold;
    }

    .countdown {
      font-size: 12px;
      color: #666;
      margin-top: 5px;
    }

    .rent-btn {
      background: #55b432;
      color: #fff;
      padding: 6px 15px;
      border-radius: 20px;
      text-decoration: none;
      transition: 0.3s;
    }

    .rent-btn:hover {
      background: #55b432;
    }

    .rent-btn.disabled {
      background: #222;
      pointer-events: none;
    }

    .no-more {
      text-align: center;
      color: #888;
      margin: 25px 0 5px;
      font-size: 14px;
    }
  </style>
</head>
<body>

  <div class="top-bar">
    <a href="javascript:history.back()" class="back-btn">←</a>
    <div class="title">📦 Investment Packages</div>
  </div>

  <main>
    @php
      use App\Models\Package;
      $packages = Package::where('status', 'active')->get()->groupBy('type');
    @endphp

    <!-- Tabs -->
    <div class="tab-buttons">
      <button class="active" onclick="showTab(event, 'fixed')">Fixed</button>
      <button onclick="showTab(event, 'welfare')">Welfare</button>
      <button onclick="showTab(event, 'activity')">Activity</button>
    </div>

    @foreach(['fixed', 'welfare', 'activity'] as $cat)
      <div class="product-tab {{ $loop->first ? 'active' : '' }}" id="{{ $cat }}">
        @foreach ($packages[$cat] ?? [] as $package)
          @php
            $isDiscounted = $package->discount_percentage > 0;
            $dailyIncome = round($package->commission_with_avg_amount / $package->validity, 2);
          @endphp
          <div class="product-box {{ $isDiscounted ? 'discount' : '' }} {{ $package->is_sold_out ? 'soldout' : '' }}">
            <div class="product-header">
              {{ $package->name }}
              <span class="badge">{{ $isDiscounted ? 'Promo' : 'Standard' }}</span>
            </div>
            <div class="product-body">
              <div class="product-content">
                <div class="product-left">
                  <img src="{{ $package->photo }}" alt="{{ $package->name }}">
                </div>
                <div class="product-info">
                  <p>Rental Amount: <span>{{ price($package->price) }} </span></p>
                  <p>Income Cycle: <span>{{ $package->validity }} Days</span></p>
                  <p>Daily Income: <span>{{ price($dailyIncome) }}</span></p>
                  <p>Est. Income: <span>{{ price($package->commission_with_avg_amount) }}</span></p>
                </div>
              </div>
              <div class="product-footer">
                <div class="price-discount">
                  @if($isDiscounted)
                    <span class="original-price">{{ price($package->price) }} </span>
                    <span class="discounted-price">{{ price($package->discounted_price) }} </span>
                  @else
                    <span class="discounted-price">{{ price($package->price) }}</span>
                  @endif
                  @if($package->show_timer)
                    <div class="countdown" data-end="{{ now()->addDays(2)->toIso8601String() }}"></div>
                  @endif
                </div>
                <a href="{{ route('product.detail', ['id' => $package->id]) }}"
                   class="rent-btn {{ $package->is_sold_out ? 'disabled' : '' }}">
                  {{ $package->is_sold_out ? 'Sold Out' : 'Rent Now' }}
                </a>
              </div>
            </div>
          </div>
        @endforeach
      </div>
    @endforeach

    <div class="no-more">— No more —</div>
  </main>

  @include('app.layout.manu')

  <script>
    function showTab(evt, tabId) {
      document.querySelectorAll('.product-tab').forEach(tab => tab.classList.remove('active'));
      document.querySelectorAll('.tab-buttons button').forEach(btn => btn.classList.remove('active'));
      document.getElementById(tabId).classList.add('active');
      evt.target.classList.add('active');
    }

    function updateCountdowns() {
      const now = new Date();
      document.querySelectorAll('.countdown').forEach(el => {
        const end = new Date(el.getAttribute('data-end'));
        const diff = end - now;
        if (diff > 0) {
          const d = Math.floor(diff / (1000 * 60 * 60 * 24));
          const h = Math.floor((diff / (1000 * 60 * 60)) % 24);
          const m = Math.floor((diff / (1000 * 60)) % 60);
          const s = Math.floor((diff / 1000) % 60);
          el.textContent = `⏳ ${d}d ${h}h ${m}m ${s}s`;
        } else {
          el.textContent = '⏰ Expired';
        }
      });
    }

    setInterval(updateCountdowns, 1000);
    updateCountdowns();
  </script>

</body>
</html>
