<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
  <title>Register</title>
  <link rel="stylesheet" href="/static/reset.css"/>
  <link rel="stylesheet" href="/static/style.css"/>
  <link rel="stylesheet" href="/static/layui.css"/>

  <style>
    .captcha-container {
      display: flex;
      align-items: center;
      gap: 10px;
    }

    canvas {
      cursor: pointer;
      border-radius: 5px;
      height: 40px;
      width: 100px;
    }

    .circlebg {
      display: flex;
      align-items: center;
      gap: 10px;
      padding: 8px;
      border: 1px solid #ccc;
      border-radius: 6px;
      margin-bottom: 12px;
      background: #fff;
    }

    .circlebg i.layui-icon {
      font-size: 18px;
    }

    .circlebg input {
      flex: 1;
      border: none;
      outline: none;
      font-size: 16px;
    }

    .password-toggle {
      cursor: pointer;
      user-select: none;
      font-size: 18px;
    }

    .loadingClass {
      display: none;
      flex-direction: column;
      align-items: center;
      justify-content: center;
      position: fixed;
      top: 0; left: 0;
      width: 100%;
      height: 100%;
      background: rgba(0, 0, 0, 0.5);
      color: #fff;
      font-size: 18px;
      z-index: 9999;
    }

    .spinner {
      width: 40px;
      height: 40px;
      border: 4px solid #fff;
      border-top: 4px solid transparent;
      border-radius: 50%;
      animation: spin 0.8s linear infinite;
      margin-bottom: 15px;
    }

    @keyframes spin {
      0% { transform: rotate(0deg); }
      100% { transform: rotate(360deg); }
    }

    #errorBox {
      color: red;
      margin: 10px 0;
      font-size: 14px;
      text-align: center;
    }

    .areaCode {
      font-weight: bold;
      display: flex;
      align-items: center;
      gap: 4px;
    }

    .areaCode img {
      width: 18px;
      height: 12px;
      object-fit: cover;
    }
  </style>
</head>
<body class="bgColor">

  <div class="top">
    <a href="#" class="topLeft">
      <i class="layui-icon layui-icon-left"></i>
    </a>
    <div class="topTit">Sign Up</div>
  </div>

  <div class="warp">
    <div class="login-head">
      <img src="{{asset('public')}}/static/img/logo.b086b4ea.png" alt="Logo">
    </div>
    <div class="login">
      <div class="loginCon">
        <form id="registerForm" class="register-form layui-form" method="post" action="{{url('register')}}">
          @csrf
          <div class="info">
            <div class="circleTit">Sign Up</div>

            <div class="circlebg">
              <i class="layui-icon layui-icon-cellphone" style="color:#009688;"></i>
              <div class="areaCode">+27 <!--img src="https://flagcdn.com/w20/ng.png" alt="NG Flag"--></div>
              <input type="text" name="phone" placeholder="Enter your phone number" lay-verify="required|phone10" required>
            </div>

            <div class="circlebg">
              <i class="layui-icon layui-icon-password" style="color:#FF5722;"></i>
              <input type="password" id="password" name="password" placeholder="Enter your password" lay-verify="required" required>
              <span class="password-toggle" onclick="togglePassword('password', this)">👁</span>
            </div>

            <div class="circlebg">
              <i class="layui-icon layui-icon-password" style="color:#9C27B0;"></i>
              <input type="password" id="withdraw_password" name="withdraw_password" placeholder="Enter Withdrawal Password" lay-verify="required" required>
              <span class="password-toggle" onclick="togglePassword('withdraw_password', this)">👁</span>
            </div>

            <div class="circlebg">
              <i class="layui-icon layui-icon-key" style="color:#3F51B5;"></i>
              <input type="text" name="ref_by" placeholder="Invitation code (Optional)">
            </div>

            <div class="circlebg captcha-container">
              <i class="layui-icon layui-icon-vercode" style="color:#E91E63;"></i>
              <input type="text" name="captcha" placeholder="Validation code" lay-verify="required" required>
              <canvas id="captchaCanvas" onclick="generateCaptcha()" title="Click to refresh" aria-label="Captcha"></canvas>
            </div>

            <div id="errorBox"></div>
          </div>

          <div class="continue">
            <button class="add-btn login-btn" lay-submit lay-filter="registerFilter">Sign Up</button>
          </div>

          <div class="continuelink">
            <a href="{{url('login')}}">I already have an account</a>
          </div>
        </form>
      </div>
    </div>
  </div>

  <div class="loadingClass" id="loadingSpinner">
    <div class="spinner"></div>
    <p>Processing...</p>
  </div>

  @include('loading')
  @include('alert-message')

  <!-- JS -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/layui/2.5.7/layui.min.js"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

  <script>
    let generatedCaptcha = "";

    function generateCaptcha() {
      const canvas = document.getElementById("captchaCanvas");
      const ctx = canvas.getContext("2d");
      const chars = "23456789";
      const codeLength = 5;
      generatedCaptcha = "";

      canvas.width = 100;
      canvas.height = 40;

      const colors = ["#00BFA5", "#6D4C41", "#795548", "#1A237E", "#FF9800"];
      ctx.fillStyle = "#ffffff";
      ctx.fillRect(0, 0, canvas.width, canvas.height);
      ctx.textBaseline = "middle";
      ctx.textAlign = "center";
      ctx.font = "bold 24px Arial";

      for (let i = 0; i < codeLength; i++) {
        const char = chars.charAt(Math.floor(Math.random() * chars.length));
        generatedCaptcha += char;
        const angle = (Math.random() - 0.5) * 0.4;
        const x = 18 + i * 18;
        const y = 20 + Math.random() * 8;

        ctx.save();
        ctx.translate(x, y);
        ctx.rotate(angle);
        ctx.fillStyle = colors[i % colors.length];
        ctx.fillText(char, 0, 0);
        ctx.restore();
      }

      ctx.strokeStyle = "#c0392b";
      ctx.lineWidth = 2;
      ctx.beginPath();
      ctx.moveTo(0, canvas.height);
      ctx.lineTo(canvas.width, 0);
      ctx.stroke();
    }

    function togglePassword(fieldId, el) {
      const input = document.getElementById(fieldId);
      if (input.type === "password") {
        input.type = "text";
        el.textContent = "🙈";
      } else {
        input.type = "password";
        el.textContent = "👁";
      }
    }

    layui.use(['form', 'layer'], function () {
      const form = layui.form;
      const layer = layui.layer;

      const fieldNames = {
        phone: 'Phone number',
        password: 'Login password',
        withdraw_password: 'Withdrawal password',
        ref_by: 'Invitation code',
        captcha: 'Captcha code'
      };

      form.verify({
        required: function (value, item) {
          if (!value.trim()) {
            return fieldNames[item.name] + ' is required';
          }
        },
        phone10: function (val) {
          if (!/^\d{10,11}$/.test(val)) {
            return 'Phone number must be 10-11 digits';
          }
        }
      });

      form.on('submit(registerFilter)', function () {
        const input = document.querySelector('input[name="captcha"]');
        if (input.value.trim().toUpperCase() !== generatedCaptcha) {
          layer.msg("Incorrect captcha code", { icon: 5 });
          generateCaptcha();
          return false;
        }

        const loading = layer.load(2, { shade: [0.3, '#000'] });

        setTimeout(() => {
          layer.close(loading);
          document.getElementById("registerForm").submit();
        }, 1000);

        return false;
      });

      // Link navigation with loading
      $('a[href]').on('click', function (e) {
        const url = $(this).attr('href');
        if (!url || url === '#' || url.startsWith('javascript')) return;
        e.preventDefault();
        const index = layer.load(2, { shade: [0.3, '#000'] });
        setTimeout(() => {
          layer.close(index);
          window.location.href = url;
        }, 1000);
      });
    });

    window.onload = generateCaptcha;
  </script>
</body>
</html>
