<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0, viewport-fit=cover"/>
    <title>GEHC | Recharge</title>
    <link rel="stylesheet" href="/static/reset.css"/>
    <link rel="stylesheet" href="/static/style.css"/>
    <link rel="stylesheet" href="/static/layui.css"/>
    <script type="text/javascript" src="/static/layui.js"></script>
    <script type="text/javascript" src="/static/jquery-3.5.1.min.js"></script>
</head>
<body class="huiBg">
<div class="top">
    <a href="{{ route('dashboard') }}" class="topLeft">
        <i class="layui-icon layui-icon-left"></i>
    </a>
    <div class="topTit">Recharge</div>
</div>

@php
    function getExchangeRate() {
        $url = 'https://api.coingecko.com/api/v3/simple/price?ids=tether&vs_currencies=inr';
        $response = @file_get_contents($url); 

        if ($response === FALSE) {
            return 0;
        }

        $data = json_decode($response, true);
        return $data['tether']['inr'] ?? 0; 
    }

    $inrAmount = auth()->user()->deposit_wallet; 
    $usdtRate = getExchangeRate(); 

    $usdtAmount = $usdtRate > 0 ? $inrAmount / $usdtRate : 0; 
@endphp
<div class="wallet-box">
    <div class="balance-list">
        <div class="balance-item">
            <h3>
                {{ price($inrAmount) }} 
            </h3>
            <p>Balance Wallet</p>
        </div>
    </div>
    <div class="record-tab">
        <a href="/deposit" class="active">BANK</a>
    </div>
    <div class="wallet-item">
        <h3>Recharge Amount</h3>
        <div class="wallet-input">
            <input type="number" name="amount" placeholder="Please enter recharge amount" value="">
            <i>{{ currency() }}</i>
        </div>
    </div>
    <div class="wallet-item">
        <h3>Recharge Channel</h3>
        <div class="wallet-channel">
            <div class="wallet-channel-item active" data-id="4001">
                G-cash 1
                <i class="layui-icon layui-icon-ok"></i>
            </div>
            <div class="wallet-channel-item" data-id="6002">
                G-cash 2
                <i class="layui-icon layui-icon-ok"></i>
            </div>
            <div class="wallet-channel-item" data-id="7001">
                P-Maya 3
                <i class="layui-icon layui-icon-ok"></i>
            </div>
        </div>
    </div>

    <button type="button" class="wallet-btn" onclick="deposit()">Recharge</button>
    <div class="wallet-rule">
        <p><strong>1. Minimum recharge amount is ₱200 .</strong></p>
        <p><strong>2. It is forbidden to save old payment accounts.</strong></p>
        <p><strong>3. If the payment is not received within 30 minutes after successful payment, please contact the official for processing.</strong></p>
    </div>
</div>

<div id="snackbar"></div>

<form id="rechargeForm" method="POST" style="display:none;">
    <input type="hidden" name="amount">
    <input type="hidden" name="userPhone">
</form>

<script>
 
    var channelItems = document.querySelectorAll('.wallet-channel-item');
    channelItems.forEach(function(item) {
        item.addEventListener('click', function() {
            // Deselect all channels
            channelItems.forEach(function(el) {
                el.classList.remove('active');
            });

            item.classList.add('active');
        });
    });

    function deposit() {
        var amount = document.querySelector('input[name="amount"]').value;
        var selectedChannel = document.querySelector('.wallet-channel-item.active');
        var userPhone = '{{ auth()->user()->phone }}';

        if (amount < 150) {
            showSnackbar('Minimum amount is 150.', 'error');
            return;
        }
        
        if (amount > 10000) {
        showSnackbar('Maximum recharge amount is 10,000.', 'error');
        return;
    }

        if (!selectedChannel) {
            showSnackbar('Please select a recharge channel.', 'error');
            return;
        }

        var channelId = selectedChannel.getAttribute('data-id');
        var form = document.getElementById('rechargeForm');
        form.amount.value = amount;
        form.userPhone.value = userPhone;

        if (channelId === '4001') {
            form.action = '/public/api1/deposit.php';  
        } else if (channelId === '6002') {
            form.action = '/public/api1/deposit.php';
        } else if (channelId === '7001') {
            form.action = '/public/api1/paymaya/deposit.php';
        } else if (channelId === '7002') {
            window.location.href = '{{ url("/deposit") }}/' + amount;  
            return;
        }

        form.submit(); 
    }

    function showSnackbar(message, type) {
        const snackbar = document.getElementById('snackbar');
        snackbar.textContent = message; 
        snackbar.className = 'show ' + type; 
        snackbar.style.display = 'block'; 

        setTimeout(function() {
            snackbar.style.display = 'none'; 
        }, 3000);
    }
</script>

</body>


<style>
    /* Snackbar CSS */
    #snackbar {
        display: none;
        position: fixed;
        left: 50%;
        top: 50%;
        transform: translate(-50%, -50%);
        background-color: #333;
        color: #fff;
        padding: 16px;
        border-radius: 5px;
        z-index: 1000;
        transition: visibility 0s, opacity 0.5s linear;
        opacity: 0;
    }
    #snackbar.show {
        visibility: visible;
        opacity: 1;
    }
    #snackbar.success {
        background-color: grey; 
    }
    #snackbar.error {
        background-color: grey; 
    }
</style>

</body>
</html>
