<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class UpdateTeamCounts extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'update:teamcounts';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Update team counts for users';

    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle()
    {
        try {
            DB::statement("
                UPDATE users u
                JOIN (
                    SELECT 
                        ref_by,
                        SUM(CASE WHEN level = 1 THEN 1 ELSE 0 END) AS lv1_team,
                        SUM(CASE WHEN level = 2 THEN 1 ELSE 0 END) AS lv2_team,
                        SUM(CASE WHEN level = 3 THEN 1 ELSE 0 END) AS lv3_team
                    FROM (
                        SELECT id, ref_by, 1 AS level FROM users
                        UNION ALL
                        SELECT u1.id, u1.ref_by, 2 AS level FROM users u1 WHERE u1.ref_by IS NOT NULL
                        UNION ALL
                        SELECT u2.id, u2.ref_by, 3 AS level FROM users u2 WHERE u2.ref_by IS NOT NULL
                    ) AS user_levels
                    GROUP BY ref_by
                ) AS level_counts ON u.id = level_counts.ref_by
                SET u.lv1_team = level_counts.lv1_team,
                    u.lv2_team = level_counts.lv2_team,
                    u.lv3_team = level_counts.lv3_team,
                    u.total_team = level_counts.lv1_team + level_counts.lv2_team + level_counts.lv3_team
                WHERE u.lv1_team = 0 OR u.lv2_team = 0 OR u.lv3_team = 0;
            ");

            $this->info('Team counts updated successfully.');
        } catch (\Exception $e) {
            $this->error('Error updating team counts: ' . $e->getMessage());
        }
    }
}
