<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use App\Console\Commands\WeeklySalaryCommand; // Make sure to import the command

class Kernel extends ConsoleKernel
{
    /**
     * Register the commands.
     */
    protected $commands = [
        WeeklySalaryCommand::class,
    ];

    /**
     * Define the application's command schedule.
     */
    protected function schedule(Schedule $schedule)
    {
        $schedule->command('salary:weekly')->saturdays()->at('00:01');
    }

    /**
     * Load the commands.
     */
    protected function commands()
    {
        $this->load(__DIR__ . '/Commands');
        require base_path('routes/console.php');
    }
}
