<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use App\Models\OtpVerification;
use App\Models\User;

class ForgotPasswordController extends Controller
{
    public function __construct()
    {
        $this->middleware('guest');
    }

    public function showOtpRequestForm()
    {
        return view('auth.forgot-password');
    }

    public function requestOtp(Request $request)
    {
        $request->validate(['phone' => 'required|numeric|exists:users,phone']);
        
        $otp = rand(1000, 9999);
        
        DB::table('otp_verifications')->updateOrInsert(
            ['phone' => $request->phone],
            ['otp' => $otp, 'created_at' => now(), 'updated_at' => now(), 'verified' => false]
        );

        $message = "Your OTP is $otp";
        $this->sendOtpToPhone($request->phone, $message);

        return response()->json(['message' => 'OTP sent successfully']);
    }

    public function verifyOtp(Request $request)
    {
        $request->validate(['phone' => 'required|numeric', 'otp' => 'required|numeric']);

        $otpRecord = OtpVerification::where('phone', $request->phone)
                                     ->where('otp', $request->otp)
                                     ->first();

        if ($otpRecord && !$otpRecord->verified) {
            $otpRecord->update([
                'verified' => true,
                'verification_token' => Str::random(60) // Generate a unique token for verification
            ]);

            return response()->json([
                'message' => 'OTP verified successfully',
                'token' => $otpRecord->verification_token // Send token back to client
            ]);
        }

        return response()->json(['message' => 'Invalid OTP'], 400);
    }

    public function updatePassword(Request $request)
    {
        $request->validate([
            'phone' => 'required|exists:users,phone',
            'password' => 'required|string|min:8|confirmed',
            'token' => 'required' // Require the verification token
        ]);

        $otpRecord = OtpVerification::where('phone', $request->phone)
                                    ->where('verification_token', $request->token)
                                    ->first();

        if (!$otpRecord || !$otpRecord->verified) {
            return response()->json(['message' => 'Unauthorized'], 401);
        }

        $user = User::where('phone', $request->phone)->firstOrFail();
        $user->password = Hash::make($request->password);
        $user->save();

        // Invalidate the token after successful password reset
        $otpRecord->delete();

        return response()->json(['message' => 'Password updated successfully']);
    }

    private function sendOtpToPhone($phone, $message)
    {

        $fields = [
            "sender_id" => "FAST2SMS",
            "message" => $message,
            "language" => "english",
            "route" => "p",
            "numbers" => $phone,
        ];

        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => "https://www.fast2sms.com/dev/bulkV2",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => json_encode($fields),
            CURLOPT_HTTPHEADER => [
                "authorization: NvX0ds2LFtrHyYlZ2KtQ2Qr3fq54LxK5yod0JuL7ncXMZatyAnCtX465q0tK",
                "accept: */*",
                "cache-control: no-cache",
                "content-type: application/json"
            ],
        ]);

        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);

        return !$err; 
    }
}
