<?php

namespace App\Http\Controllers;

use App\Models\Deposit;
use Carbon\Carbon;
use Illuminate\Http\Request;

class DepositStatusController extends Controller
{
    public function changePendingStatus()
    {

        $currentTime = Carbon::now('Asia/Kolkata'); 

        $depositsToReject = Deposit::where('status', 'pending')
            ->where('created_at', '<', $currentTime->subMinutes(10))
            ->get();

        foreach ($depositsToReject as $deposit) {
            $deposit->status = 'rejected';
            $deposit->save();
        }

        return response()->json([
            'message' => 'Deposit statuses updated successfully',
            'updated_count' => $depositsToReject->count(),
        ]);
    }
}
