<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\UserLedger;
use App\Models\Deposit;
use Carbon\Carbon;
use Illuminate\Support\Facades\Validator;

class RewardController extends Controller
{
    protected $weeklyTiers = [
        1 => 100,
        10 => 500,
        20 => 2000,
    ];

    protected $monthlyTiers = [
        20 => 2000,
        10 => 1000,
        5 => 500,
    ];

    /*public function showDailyReward()
    {
        $user = Auth::user();

        $first_level_users = User::where('ref_by', $user->ref_id)
            ->whereHas('deposits', function ($query) {
                $query->where('status', 'approved'); 
            })
            ->where('created_at', '>=', Carbon::now()->subDay())
            ->get(); 

        $first_level_invite_count = $first_level_users->count();

        $claimed_rewards = UserLedger::where('user_id', $user->id)
            ->where('reason', 'daily_reward')
            ->where('claimed', true)
            ->pluck('amount')
            ->toArray();

        $second_level_users = User::whereIn('ref_by', $first_level_users->pluck('ref_id'))
            ->whereHas('deposits', function ($query) {
                $query->where('status', 'approved');
            })
            ->get(); 

        $third_level_users = User::whereIn('ref_by', $second_level_users->pluck('ref_id'))
            ->whereHas('deposits', function ($query) {
                $query->where('status', 'approved');
            })
            ->get(); 

        $team_size =  $second_level_users->count() + $third_level_users->count();

        $team_users = User::whereIn('ref_by', $first_level_users->pluck('id'))->get();
        $team_count = $team_users->count();

        return view('app.main.reward', [
            'first_level_invite_count' => $first_level_invite_count,
            'claimed_rewards' => $claimed_rewards,
            'team_count' => $team_count,
            'total_count' => $team_size,
        ]);
    }*/
    public function showDailyReward()
{
    $user = Auth::user();

    $first_level_users = User::where('ref_by', $user->ref_id)
        ->whereHas('deposits', function ($query) {
            $query->where('status', 'approved'); 
        })
        ->where('created_at', '>=', Carbon::now()->subDay())
        ->get(); 

    $first_level_invite_count = $first_level_users->count();

    $claimed_rewards = UserLedger::where('user_id', $user->id)
        ->where('reason', 'daily_reward')
        ->where('claimed', true)
        ->pluck('amount')
        ->toArray();

    $second_level_users = User::whereIn('ref_by', $first_level_users->pluck('ref_id'))
        ->whereHas('deposits', function ($query) {
            $query->where('status', 'approved');
        })
        ->get(); 

    $third_level_users = User::whereIn('ref_by', $second_level_users->pluck('ref_id'))
        ->whereHas('deposits', function ($query) {
            $query->where('status', 'approved');
        })
        ->get(); 

    $team_size = $second_level_users->count() + $third_level_users->count();

    $team_users = User::whereIn('ref_by', $first_level_users->pluck('id'))->get();
    $team_count = $team_users->count();

    // 📦 Valid invites for full salary logic
    $valid_invite_count = User::where('ref_by', $user->ref_id)
        ->whereHas('deposits', function ($query) {
            $query->where('status', 'approved');
        })
        ->count();

    // 🧮 Weekly salary breakdown
    $weekly_salaries = [];
    foreach ($this->weeklyTiers as $required => $bonus) {
        $weekly_salaries[] = [
            'required' => $required,
            'bonus' => $bonus
        ];
    }

    $claimed_weekly_bonuses = UserLedger::where('user_id', $user->id)
        ->where('reason', 'weekly_salary')
        ->pluck('amount')
        ->toArray();

    // 🧮 Monthly salary logic
    $monthly_salary = 0;
    foreach ($this->monthlyTiers as $required => $bonus) {
        if ($valid_invite_count >= $required) {
            $monthly_salary = $bonus;
            break;
        }
    }

    $monthly_salary_claimed = UserLedger::where('user_id', $user->id)
        ->where('reason', 'monthly_salary')
        ->whereMonth('created_at', Carbon::now()->month)
        ->whereYear('created_at', Carbon::now()->year)
        ->exists();

    return view('app.main.reward', [
        'first_level_invite_count' => $first_level_invite_count,
        'claimed_rewards' => $claimed_rewards,
        'team_count' => $team_count,
        'total_count' => $team_size,

        // ✅ New variables passed to view
        'weekly_salaries' => $weekly_salaries,
        'current_invite_count' => $valid_invite_count,
        'claimed_weekly_bonuses' => $claimed_weekly_bonuses,
        'monthly_salary' => $monthly_salary,
        'monthly_salary_claimed' => $monthly_salary_claimed,
        'monthly_invite_count' => $valid_invite_count,
    ]);
}


    public function claimDailyReward(Request $request)
    {
        $user = Auth::user();
        $rewards = [
            3 => 100,
            5 => 200,
            10 => 500,
            20 => 1000
        ];

        $first_level_invite_count = User::where('ref_by', $user->ref_id)
            ->whereHas('deposits', function ($query) {
                $query->where('status', 'approved');
            })
            ->whereDate('created_at', Carbon::today())
            ->count();

        $reward_amount = 0;

        $lastClaim = UserLedger::where('user_id', $user->id)
            ->where('reason', 'daily_reward')
            ->whereDate('created_at', Carbon::today())
            ->first();

        if ($lastClaim) {
            return response()->json([
                'status' => 'error',
                'message' => 'You have already claimed your daily reward today.'
            ]);
        }

        foreach ($rewards as $invite_goal => $bonus) {
            if ($first_level_invite_count >= $invite_goal) {
                $reward_amount = max($reward_amount, $bonus);
            }
        }

        if ($reward_amount > 0) {
            try {
                $user->balance += $reward_amount;
                $user->total_income += $reward_amount;
                $user->today_income += $reward_amount;
                $user->team_income += $reward_amount;
                $user->save();

                UserLedger::create([
                    'user_id' => $user->id,
                    'reason' => 'daily_reward',
                    'amount' => $reward_amount,
                    'credit' => $reward_amount,
                    'debit' => 0,
                    'status' => 'approved',
                    'date' => now()->format('d-m-Y H:i'),
                    'claimed' => true,
                ]);

                return response()->json([
                    'status' => 'success',
                    'message' => "You've received Rs. $reward_amount!",
                    'balance' => $user->balance
                ]);
            } catch (\Exception $e) {
                \Log::error('Error claiming daily reward: ' . $e->getMessage());
                return response()->json([
                    'status' => 'error',
                    'message' => 'An error occurred while claiming your reward.'
                ]);
            }
        }

        return response()->json([
            'status' => 'error',
            'message' => 'Daily invite requirements not met for reward.'
        ]);
    }

    public function claimWeeklySalary()
{
    $user = Auth::user();

    // ✅ Use Nigeria timezone (Africa/Lagos)
    $nowInNigeria = Carbon::now('Africa/Lagos');

    if (!$nowInNigeria->isSaturday()) {
        return response()->json([
            'status' => 'error',
            'message' => 'Weekly salary can only be claimed on Saturdays (Nigeria time).',
        ]);
    }

    // Count valid referrals with approved deposits
    $validInvites = User::where('ref_by', $user->ref_id)
        ->whereHas('deposits', function ($query) {
            $query->where('status', 'approved');
        })->count();

    // Determine salary based on tiers
    $salary = 0;
    $eligibleInviteCount = 0;
    foreach ($this->weeklyTiers as $min => $amount) {
        if ($validInvites >= $min) {
            $salary = $amount;
            $eligibleInviteCount = $min;
            break;
        }
    }

    if ($salary == 0) {
        return response()->json([
            'status' => 'error',
            'message' => 'You are not eligible for weekly salary yet.',
        ]);
    }

    // Prevent re-claim in the same week
    $alreadyClaimed = UserLedger::where('user_id', $user->id)
        ->where('reason', 'weekly_salary')
        ->whereBetween('created_at', [
            $nowInNigeria->copy()->startOfWeek(),
            $nowInNigeria->copy()->endOfWeek()
        ])
        ->exists();

    if ($alreadyClaimed) {
        return response()->json([
            'status' => 'error',
            'message' => 'You have already claimed your weekly salary this week.',
        ]);
    }

    // Allow claim if user has ever qualified
    $previous_qualification = UserLedger::where('user_id', $user->id)
        ->where('reason', 'weekly_salary')
        ->where('amount', $salary)
        ->exists();

    if (!$previous_qualification && $validInvites < $eligibleInviteCount) {
        return response()->json([
            'status' => 'error',
            'message' => 'You must meet the invite requirement at least once.',
        ]);
    }

    // Grant the salary
    try {
        $user->balance += $salary;
        $user->total_income += $salary;
        $user->team_income += $salary;
        $user->save();

        UserLedger::create([
            'user_id' => $user->id,
            'reason' => 'weekly_salary',
            'amount' => $salary,
            'credit' => $salary,
            'debit' => 0,
            'status' => 'approved',
            'claimed' => true,
            'date' => now('Africa/Lagos')->format('d-m-Y H:i'),
        ]);

        return response()->json(['status' => true, 'message' => "You've received R. $salary weekly salary!",
            'balance' => $user->balance
        ]);
    } catch (\Exception $e) {
        \Log::error('Error claiming weekly salary: ' . $e->getMessage());
        return response()->json([
            'status' => 'error',
            'message' => 'An error occurred while claiming your salary.'
        ]);
    }
}

    public function claimMonthlySalary()
    {
        $user = Auth::user();

        $validInvites = User::where('ref_by', $user->ref_id)
            ->whereHas('deposits', function ($query) {
                $query->where('status', 'approved');
            })->count();

        $salary = 0;
        foreach ($this->monthlyTiers as $min => $amount) {
            if ($validInvites >= $min) {
                $salary = $amount;
                break;
            }
        }

        $now = Carbon::now();
        $alreadyClaimed = UserLedger::where('user_id', $user->id)
            ->where('reason', 'monthly_salary')
            ->whereMonth('created_at', $now->month)
            ->whereYear('created_at', $now->year)
            ->exists();

        if ($alreadyClaimed) {
            return response()->json([
                'status' => 'error',
                'message' => 'You have already claimed your monthly salary this month.',
            ]);
        }

        if ($salary == 0) {
            return response()->json([
                'status' => 'error',
                'message' => 'You are not eligible for monthly salary yet.',
            ]);
        }

        try {
            $user->balance += $salary;
            $user->total_income += $salary;
            $user->team_income += $salary;
            $user->save();

            UserLedger::create([
                'user_id' => $user->id,
                'reason' => 'monthly_salary',
                'amount' => $salary,
                'credit' => $salary,
                'debit' => 0,
                'status' => 'approved',
                'claimed' => true,
                'date' => now()->format('d-m-Y H:i'),
            ]);

            return response()->json([
                'status' => 'true',
                'message' => "You've received Rs. $salary monthly salary!",
                'balance' => $user->balance
            ]);
        } catch (\Exception $e) {
            \Log::error('Error claiming monthly salary: ' . $e->getMessage());
            return response()->json([
                'status' => 'error',
                'message' => 'An error occurred while claiming your salary.'
            ]);
        }
    }
}
