<?php

namespace App\Http\Controllers\Webhook;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Withdraw;

class PayoutWebhookController extends Controller
{
    public function handle(Request $request)
    {
        // Log or debug the payload
        \Log::info('Webhook Received:', $request->all());

        // Example payload keys (adjust based on your gateway's response)
        $reference = $request->input('reference'); // your transaction/order_ref
        $status    = $request->input('status'); // e.g., 'approved', 'rejected', 'failed'

        // Find the withdrawal record by reference
        $withdraw = Withdraw::where('order_ref', $reference)->first();

        if (!$withdraw) {
            return response()->json(['message' => 'Withdraw not found'], 404);
        }

        // Map gateway status to your local DB values
        if (in_array($status, ['approved', 'success', 'successful'])) {
            $withdraw->status = 'approved';
        } elseif (in_array($status, ['rejected', 'failed'])) {
            $withdraw->status = 'rejected';
        } else {
            $withdraw->status = 'pending';
        }

        $withdraw->save();

        return response()->json(['message' => 'Status updated'], 200);
    }
}
