<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Admin;
use App\Models\Fund;
use App\Models\User;

use App\Models\Package;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class FundController extends Controller
{
    public $route = 'admin.fund';
    public function index()
    {
        $funds = Fund::get();
        return view('admin.pages.fund.index', compact('funds'));
    }
    public function create($id=null)
    {
        $data = null;
        if ($id){
            $data = Fund::find($id);
        }
        return view('admin.pages.fund.insert', compact('data'));
    }

    public function view($id=null)
    {
        $data = Fund::find($id);
        return view('admin.pages.fund.view', compact('data'));
    }

    public function insert_or_update(Request $request)
    {
        $this->validate($request,[
            'name'=> 'required',
            'title'=> 'required',
            'commission'=> 'required',
            'validity'=> 'required',
            'minimum_invest'=> 'required|numeric',
        ]);
        if ($request->id){
            $model = Fund::findOrFail($request->id);
            $model->status = $request->status;
        }else{
            $model = new Fund();
        }

        $path = uploadImage(false ,$request, 'photo', 'upload/fund/', 200, 200 ,$model->photo);
        $model->photo = $path ?? $model->photo;

        $model->name = $request->name;
        $model->title = $request->title;
        $model->minimum_invest = $request->minimum_invest;
        $model->commission = $request->commission;
        $model->validity = $request->validity;
        $model->save();
        return redirect()->route($this->route.'.index')->with('success', $request->id ? 'Fund Updated Successful.' : 'Package Created Successful.');
    }

    public function delete($id)
    {
        $model = Fund::find($id);
        $model->delete();
        return redirect()->route($this->route.'.index')->with('success','Item Deleted Successful.');
    }
    // ------------------ WEEKLY SALARY ------------------
    public function weeklySalary()
    {
        $admin = Admin::first();

        // Prevent duplicate salary for today
        if ($admin->weekly_salary_date == date('Y-m-d')) {
            return back()->with('error', 'Weekly salary already processed today');
        }

        $users = User::all();
        $totalPaid = 0;

        foreach ($users as $user) {
            $validInvites = User::where('ref_by', $user->ref_id)
                ->whereHas('deposits', function ($query) {
                    $query->where('status', 'approved');
                })
                ->count();

            $salary = 0;
            if ($validInvites >= 19) {
                $salary = 500;
            } elseif ($validInvites >= 6) {
                $salary = 250;
            } elseif ($validInvites >= 3) {
                $salary = 100;
            }

            if ($salary > 0) {
                $user->balance += $salary;
                $user->total_income += $salary;
                $user->team_income += $salary;
                $user->save();

                UserLedger::create([
                    'user_id' => $user->id,
                    'reason' => 'weekly_salary',
                    'amount' => $salary,
                    'credit' => $salary,
                    'debit' => 0,
                    'status' => 'approved',
                    'claimed' => true,
                    'date' => now()->format('d-m-Y H:i'),
                ]);

                $totalPaid += $salary;
            }
        }

        $admin->weekly_salary_date = date('Y-m-d');
        $admin->save();

        return back()->with('success', "Weekly Salary Processed. Total paid: ₦$totalPaid");
    }

    // ------------------ MONTHLY SALARY ------------------
    public function monthlySalary()
    {
        $admin = Admin::first();

        // Only run on the 28th
        if (date('d') != '28') {
            return back()->with('error', 'Monthly salary can only be processed on the 28th');
        }

        // Prevent duplicate
        if ($admin->monthly_salary_date == date('Y-m-d')) {
            return back()->with('error', 'Monthly salary already processed today');
        }

        $users = User::all();
        $totalPaid = 0;

        foreach ($users as $user) {
            $validInvites = User::where('ref_by', $user->ref_id)
                ->whereHas('deposits', function ($query) {
                    $query->where('status', 'approved');
                })
                ->count();

            $salary = 0;
            if ($validInvites >= 19) {
                $salary = 500;
            } elseif ($validInvites >= 6) {
                $salary = 250;
            } elseif ($validInvites >= 3) {
                $salary = 100;
            }

            if ($salary > 0) {
                $user->balance += $salary;
                $user->total_income += $salary;
                $user->team_income += $salary;
                $user->save();

                UserLedger::create([
                    'user_id' => $user->id,
                    'reason' => 'monthly_salary',
                    'amount' => $salary,
                    'credit' => $salary,
                    'debit' => 0,
                    'status' => 'approved',
                    'claimed' => true,
                    'date' => now()->format('d-m-Y H:i'),
                ]);

                $totalPaid += $salary;
            }
        }

        $admin->monthly_salary_date = date('Y-m-d');
        $admin->save();

        return back()->with('success', "Monthly Salary Processed. Total paid: ₦$totalPaid");
    }
}
