<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Package;
use Illuminate\Http\Request;

class PackageController extends Controller
{
    public $route = 'admin.package';

    public function index()
    {
        $packages = Package::get();
        return view('admin.pages.package.index', compact('packages'));
    }

    public function create($id = null)
    {
        $data = $id ? Package::find($id) : null;
        return view('admin.pages.package.insert', compact('data'));
    }

    public function view($id = null)
    {
        $data = Package::findOrFail($id);
        return view('admin.pages.package.view', compact('data'));
    }

    public function insert_or_update(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|string|max:255',
            'title' => 'nullable|string|max:255',
            'price' => 'required|numeric|min:0',
            'validity' => 'required|integer|min:1',
            'commission_with_avg_amount' => 'required|numeric|min:0',
            'discount_percentage' => 'nullable|numeric|min:0|max:100',
            'discounted_price' => 'nullable|numeric|min:0',
            'type' => 'required|in:fixed,welfare,activity',
            'status' => 'required|in:active,inactive',
            'is_sold_out' => 'nullable|boolean',
            'show_timer' => 'nullable|boolean',
            'is_default' => 'nullable|in:1,0',
            'buy_limit' => 'nullable|integer|min:0',
            'desc' => 'nullable|string',
            'photo' => 'nullable|image|mimes:jpeg,png,jpg|max:2048',
        ]);

        $model = $request->id ? Package::findOrFail($request->id) : new Package();

        // Image upload
        if ($request->hasFile('photo')) {
            $model->photo = uploadImage(false, $request, 'photo', 'upload/package/', 200, 200, $model->photo);
        }

        // Assign values
        $model->name = $request->name;
        $model->title = $request->title;
        $model->price = $request->price;
        $model->validity = $request->validity;
        $model->commission_with_avg_amount = $request->commission_with_avg_amount;
        $model->discount_percentage = $request->discount_percentage ?? 0;
        $model->discounted_price = $request->discounted_price;
        $model->is_sold_out = $request->is_sold_out ?? 0;
        $model->show_timer = $request->show_timer ?? 0;
        $model->status = $request->status;
        $model->type = $request->type;
        $model->buy_limit = $request->buy_limit ?? 0;
        $model->is_default = $request->is_default ?? '0';
        $model->desc = $request->desc;

        $model->save();

        return redirect()->route($this->route . '.index')->with('success', $request->id ? 'Package Updated Successfully.' : 'Package Created Successfully.');
    }

    public function delete($id)
    {
        $model = Package::findOrFail($id);
        deleteImage($model->photo);
        $model->delete();

        return redirect()->route($this->route . '.index')->with('success', 'Package Deleted Successfully.');
    }
}
