<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Service;
use Illuminate\Http\Request;

class ServicesController extends Controller
{
    public function index()
    {
        $services = Service::all();
        return view('admin.services.index', compact('services'));
    }

    public function edit($id)
    {
        $service = Service::findOrFail($id);
        
        return view('admin.services.edit', compact('service'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'link' => 'required|url',
        ]);

        $service = Service::findOrFail($id);
        
        $service->link = $request->input('link');
        $service->save();

        return redirect()->route('admin.service.index')->with('success', 'Service link updated successfully.');
    }
    
    public function destroy($id)
    {
        $service = Service::findOrFail($id);
        $service->delete();

        return redirect()->route('admin.service.index')->with('success', 'Service deleted successfully.');
    }
}
