<?php

namespace App\Http\Controllers\user;

use App\Http\Controllers\Controller;
use App\Models\PaymentMethod;
use App\Models\User;
use App\Models\Deposit;
use App\Models\UserLedger;
use App\Models\Withdrawal;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;

class WithdrawController extends Controller
{
    public function withdraw()
    {
        return view('app.main.withdraw.index');
    }

    public function withdraw_history()
    {
        return view('app.main.withdraw_history');
    }

   public function withdrawRequest(Request $request)
{
    $validate = Validator::make($request->all(), [
        'amount' => 'required|numeric|min:180', 
    ]);

    if (setting('w_time_status') == 'inactive') {
        return redirect()->back()->with('error', 'Withdrawal channels will be opened soon, we will announce you in group please be active');
    }

    if ($validate->fails()) {
        return redirect()->back()->withErrors($validate);
    }

    $user = Auth::user();


    $lastWithdrawal = Withdrawal::where('user_id', $user->id)
        ->orderBy('created_at', 'desc')
        ->first();

    if ($lastWithdrawal && $lastWithdrawal->created_at->diffInHours(now()) < 24) {
        return redirect()->back()->with('error', 'You can only make one withdrawal every 24 hours.');
    }

    $approvedWithdrawal = Withdrawal::where('user_id', $user->id)
        ->where('status', 'approved')
        ->first();

    if ($approvedWithdrawal) {
        return redirect()->back()->with('error', 'You can place only 1 Withdrawal.');
    }

    if ($request->amount <= $user->balance) {

        if ($request->amount >= setting('minimum_withdraw') && $request->amount <= setting('maximum_withdraw')) {

            $charge = 0;
            if (setting('withdraw_charge') > 0) {
                $charge = ($request->amount * setting('withdraw_charge')) / 100;
            }

            $balance = $user->balance - $request->amount;
            User::where('id', $user->id)->update(['balance' => $balance]);

            $withdrawal = new Withdrawal();
            $withdrawal->user_id = $user->id;
            $withdrawal->method_name = $user->gateway_method;
            $withdrawal->number = $user->gateway_number;
            $withdrawal->amount = $request->amount;
            $withdrawal->currency = 'Bangladesh';
            $withdrawal->charge = $charge;
            $withdrawal->oid = 'W-' . rand(100000, 999999); 
            $withdrawal->final_amount = $request->amount - $charge;
            $withdrawal->status = 'pending'; 

            if ($withdrawal->save()) {

                $ledger = new UserLedger();
                $ledger->user_id = $user->id;
                $ledger->reason = 'withdraw_request';
                $ledger->perticulation = 'withdraw request status is pending';
                $ledger->amount = $request->amount - $charge;
                $ledger->debit = $request->amount - $charge;
                $ledger->status = 'pending';
                $ledger->date = now(); 
                $ledger->save();

                return redirect('/home')->with('success', 'Withdraw request sent successfully');
            }
        } else {
            return redirect()->back()->with('error', 'Amount must be between ' . setting('minimum_withdraw') . ' and ' . setting('maximum_withdraw'));
        }
    } else {
        return redirect()->back()->with('error', 'Insufficient Balance');
    }
}
}