<?php

namespace App\Http\Controllers\user;

use App\Http\Controllers\Controller;
use App\Models\Rebate;
use App\Models\User;
use App\Models\Purchase;
use App\Models\UserLedger;
use Illuminate\Support\Facades\Auth;

class MiningController extends Controller
{
    public function received_amount()
{
    $user = Auth::user();
    if ($user->receive_able_amount > 0) {
        $uu = User::where('id', $user->id)->first();
        $uu->balance = $user->balance + $user->receive_able_amount;

        // Increment the relevant fields
        $uu->increment('total_income', $user->receive_able_amount);
        $uu->increment('today_income', $user->receive_able_amount);
        $uu->increment('product_income', $user->receive_able_amount);

        // Create a ledger entry for the received commission
        $ledger = new UserLedger();
        $ledger->user_id = $user->id;
        $ledger->reason = 'daily_income';
        $ledger->perticulation = 'Package commission Received.';
        $ledger->amount = $user->receive_able_amount;
        $ledger->credit = $user->receive_able_amount;
        $ledger->status = 'approved';
        $ledger->date = date("Y-m-d H:i:s");
        $ledger->save();

        // Reset the receive_able_amount to 0 after processing
        $uu->receive_able_amount = 0;
        $uu->save();

        return response()->json(['status'=> true, 'message'=> 'Commission Received.', 'balance'=> price($uu->receive_able_amount)]);
    } else {
        return response()->json(['status'=> true, 'message'=> 'Waiting for commission to be added', 'balance'=> price($user->receive_able_amount)]);
    }
}

}








