<?php

namespace App\Http\Controllers\user;

use App\Http\Controllers\Controller;
use App\Http\Services\PaymentServices;
use App\Models\Admin;
use App\Models\BonusLedger;
use App\Models\Checkin;
use App\Models\Commission;
use App\Models\Deposit;
use App\Models\BankList;
use App\Models\Fund;
use App\Models\Improvment;
use App\Models\Mining;
use App\Models\Notice;
use App\Models\Package;
use App\Models\PaymentMethod;
use App\Models\Setting;
use App\Models\Purchase;
use App\Models\Task;
use App\Models\User;
use App\Models\UserLedger;
use App\Models\VipSlider;
use App\Models\Withdrawal;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;

class UserController extends Controller
{
    public function dashboard()
    {
        return view('app.main.index');
    }


    public function return_pay_number($method){
        $method = DB::table('payment_methods')->where('type', $method)->inRandomOrder()->first();
        return response()->json(['status'=> true, 'data'=> $method]);
    }


    public function vip()
    {
        return view('app.main.vip');
    }

    public function message()
    {
        return view('app.main.message');
    }

    public function purchase_history()
    {
        return view('app.main.purchase_history');
    }

  public function history()
{
    $userId = auth()->id();

    $cashRecords = UserLedger::where('user_id', $userId)
    ->whereIn('reason', ['daily_income', 'commission', 'claim', 'my_commission', 'product_purchase', 'withdraw_request', 'withdraw_approved', 'reg_bonus', 'referral_bonus', 'income_commission','check_in_reward'])
    ->orderBy('created_at', 'desc') 
    ->get()
    ->map(function ($record) {

        $levelPrefix = '';
        switch ($record->step) {
            case 'first':
                $levelPrefix = '1st Level ';
                break;
            case 'second':
                $levelPrefix = '2nd Level ';
                break;
            case 'third':
                $levelPrefix = '3rd Level ';
                break;
        }

        switch ($record->reason) {
            case 'daily_income':
                $record->title = 'Product Income';
                break;
            case 'product_purchase':
                $record->title = 'Product Purchase';
                break;
            case 'commission':
                $record->title = "{$levelPrefix}Rebate Bonus";
                break;
            case 'claim':
                $record->title = 'Treasure Bonus';
                break;
            case 'withdraw_request':
                $record->title = 'Withdraw Request';
                break;
            case 'withdraw_approved':
                $record->title = 'Withdraw Successful';
                break;
            case 'referral_bonus':
                $record->title = 'Referral Bonus';
                break;
            case 'check_in_reward':
                $record->title = 'Daily Check-in';
                break;
            case 'reg_bonus':
                $record->title = 'Newbie Bonus';
                break;
            case 'income_commission':
                $record->title = "{$levelPrefix}Income Commission";
                break;
            default:
                $record->title = ucfirst($record->reason);
                break;
        }

        return $record;
    });


    $rechargeRecords = Deposit::where('user_id', $userId)
        ->whereIn('status', ['pending', 'approved', 'rejected'])
        ->orderBy('created_at', 'desc')
        ->paginate(15) 
        ->withQueryString(); 

    $withdrawRecords = Withdrawal::where('user_id', $userId)
        ->whereIn('status', ['pending', 'approved', 'rejected'])
        ->orderBy('created_at', 'desc')
        ->paginate(15) 
        ->withQueryString(); 

    return view('app.main.history', compact('cashRecords', 'rechargeRecords', 'withdrawRecords'));
}

    public function history_all()
    {
        return view('app.main.history_all');
    }

    public function ordered()
    {
        return view('app.main.ordered');
    }


    public function exchange()
    {
        return view('app.main.exchange');
    }

    public function checkin()
    {
        $user = \auth()->user();
        if ($user->checkin > 0){
            $checkin = new Checkin();
            $checkin->user_id = $user->id;
            $checkin->date = date('Y-m-d');
            $checkin->amount = $user->checkin;
            $checkin->save();

            $userUpdate = User::where('id', $user->id)->first();
            $userUpdate->balance = $user->balance + $user->checkin;
            $userUpdate->checkin = 0;
            $userUpdate->save();

            $ledger = new UserLedger();
            $ledger->user_id = $user->id;
            $ledger->reason = 'checkin';
            $ledger->perticulation = 'checkin commission received';
            $ledger->amount = $user->checkin;
            $ledger->debit = $user->checkin;
            $ledger->status = 'approved';
            $ledger->step = 'third';
            $ledger->date = date('d-m-Y H:i');
            $ledger->save();

            return response()->json(['message'=>'Check-in balance received.']);
        }else{
            return response()->json(['message'=>'Check-in balance 0']);
        }
    }

    public function vip_commission()
    {
        return view('app.main.vip_commission');
    }

    public function task()
    {
        $user = Auth::user();
        //First Level Users
        $first_level_users = User::where('ref_by', $user->ref_id)->get();
        $first_level_users_ids = [];
        foreach ($first_level_users as $user) {
            array_push($first_level_users_ids, $user->id);
        }

        //Second Level Users
        $second_level_users_ids = [];
        foreach ($first_level_users as $element) {
            $users = User::where('ref_by', $element->ref_id)->get();
            foreach ($users as $user) {
                array_push($second_level_users_ids, $user->id);
            }
        }
        $second_level_users = User::whereIn('id', $second_level_users_ids)->get();

        //Third Level Users
        $third_level_users_ids = [];
        foreach ($second_level_users as $element) {
            $users = User::where('ref_by', $element->ref_id)->get();
            foreach ($users as $user) {
                array_push($third_level_users_ids, $user->id);
            }
        }
        $third_level_users = User::whereIn('id', $third_level_users_ids)->get();
        $team_size = $first_level_users->count() + $second_level_users->count() + $third_level_users->count();

        //Get level wise user ids
        $first_ids = $first_level_users->pluck('id'); //first
        $second_ids = $second_level_users->pluck('id'); //Second
        $third_ids = $third_level_users->pluck('id'); //Third

        $lv1Recharge = Deposit::whereIn('user_id', $first_ids)->where('status', 'approved')->sum('amount');
        $lv2Recharge = Deposit::whereIn('user_id', $second_ids)->where('status', 'approved')->sum('amount');
        $lv3Recharge = Deposit::whereIn('user_id', $third_ids)->where('status', 'approved')->sum('amount');
        $lvTotalDeposit = $lv1Recharge + $lv2Recharge + $lv3Recharge;

        $lv1Withdraw = Withdrawal::whereIn('user_id', $first_ids)->where('status', 'approved')->sum('amount');
        $lv2Withdraw = Withdrawal::whereIn('user_id', $second_ids)->where('status', 'approved')->sum('amount');
        $lv3Withdraw = Withdrawal::whereIn('user_id', $third_ids)->where('status', 'approved')->sum('amount');
        $lvTotalWithdraw = $lv1Withdraw + $lv2Withdraw + $lv3Withdraw;

        $activeMembers1 = Deposit::whereIn('user_id', $first_ids)->where('status', 'approved')->groupBy('user_id')->count();
        $activeMembers2 = Deposit::whereIn('user_id', $second_ids)->where('status', 'approved')->groupBy('user_id')->count();
        $activeMembers3 = Deposit::whereIn('user_id', $third_ids)->where('status', 'approved')->groupBy('user_id')->count();


        $Lv1active = 0;
        $Lv2active = 0;
        $Lv3active = 0;

        foreach ($first_level_users as $uuss) {
            $purchase = Purchase::where('user_id', $uuss->id)->first();
            if ($purchase) {
                $Lv1active = $Lv1active + 1;
            }
        }
        foreach ($second_level_users as $uuss) {
            $purchase = Purchase::where('user_id', $uuss->id)->first();
            if ($purchase) {
                $Lv2active = $Lv2active + 1;
            }
        }
        foreach ($third_level_users as $uuss) {
            $purchase = Purchase::where('user_id', $uuss->id)->first();
            if ($purchase) {
                $Lv3active = $Lv3active + 1;
            }
        }

        $teamTotalActiveMembers = $Lv1active + $Lv2active + $Lv3active;


        return view('app.main.task', compact('team_size', 'teamTotalActiveMembers', 'lv1Recharge', 'lv2Recharge', 'lv3Recharge', 'lv1Withdraw', 'lv2Withdraw', 'lv3Withdraw', 'first_level_users', 'second_level_users', 'third_level_users'));
    }

    public function task_history()
    {
        return view('app.main.task_history');
    }

    public function reword_history()
    {
        return view('app.main.reword_history');
    }

    public function recharge_history()
    {
        return view('app.main.deposit_history');
    }

    public function commission()
    {
        return view('app.main.commission');
    }

    public function amount_history()
    {
        return view('app.main.amount_history');
    }

    public function package_details($id)
    {
        $package = Package::find($id);
        return view('app.main.package_details', compact('package'));
    }

   public function profile()
{
    $user = Auth::user();

    // First Level Users with Referrer Info
    $first_level_users = User::where('ref_by', $user->ref_id)
        ->with('referrer')
        ->get();

    $first_level_users_ids = $first_level_users->pluck('id')->toArray();

    // Second Level Users with Referrer Info
    $second_level_users = User::whereIn('ref_by', $first_level_users->pluck('ref_id')->toArray())
        ->with('referrer')
        ->get();

    // Third Level Users with Referrer Info
    $third_level_users = User::whereIn('ref_by', $second_level_users->pluck('ref_id')->toArray())
        ->with('referrer')
        ->get();

    $team_size = $first_level_users->count() + $second_level_users->count() + $third_level_users->count();

    $first_ids = $first_level_users->pluck('id');
    $second_ids = $second_level_users->pluck('id');
    $third_ids = $third_level_users->pluck('id');

    // Recharge calculations
    $lv1Recharge = Deposit::whereIn('user_id', $first_ids)->where('status', 'approved')->sum('amount');
    $lv2Recharge = Deposit::whereIn('user_id', $second_ids)->where('status', 'approved')->sum('amount');
    $lv3Recharge = Deposit::whereIn('user_id', $third_ids)->where('status', 'approved')->sum('amount');
    $lvTotalDeposit = $lv1Recharge + $lv2Recharge + $lv3Recharge;

    // Withdrawal calculations
    $lv1Withdraw = Withdrawal::whereIn('user_id', $first_ids)->where('status', 'approved')->sum('amount');
    $lv2Withdraw = Withdrawal::whereIn('user_id', $second_ids)->where('status', 'approved')->sum('amount');
    $lv3Withdraw = Withdrawal::whereIn('user_id', $third_ids)->where('status', 'approved')->sum('amount');
    $lvTotalWithdraw = $lv1Withdraw + $lv2Withdraw + $lv3Withdraw;

    // Active members
    $activeMembers1 = Deposit::whereIn('user_id', $first_ids)->where('status', 'approved')->groupBy('user_id')->count();
    $activeMembers2 = Deposit::whereIn('user_id', $second_ids)->where('status', 'approved')->groupBy('user_id')->count();
    $activeMembers3 = Deposit::whereIn('user_id', $third_ids)->where('status', 'approved')->groupBy('user_id')->count();

    // Investment totals
    $totalInvestment = Purchase::whereIn('user_id', array_merge($first_ids->toArray(), $second_ids->toArray(), $third_ids->toArray()))->sum('amount');
    $totalLevelInvest1 = Purchase::whereIn('user_id', $first_ids->toArray())->sum('amount');
    $totalLevelInvest2 = Purchase::whereIn('user_id', $second_ids->toArray())->sum('amount');
    $totalLevelInvest3 = Purchase::whereIn('user_id', $third_ids->toArray())->sum('amount');

    // Commission totals
    $levelTotalCommission1 = UserLedger::where('user_id', auth()->id())->where('reason', 'commission')->where('step', 'first')->sum('amount');
    $levelTotalCommission2 = UserLedger::where('user_id', auth()->id())->where('reason', 'commission')->where('step', 'second')->sum('amount');
    $levelTotalCommission3 = UserLedger::where('user_id', auth()->id())->where('reason', 'commission')->where('step', 'third')->sum('amount');

    // Calculate Today's Income (Daily income + level commissions)
    $todayDailyIncome = UserLedger::where('user_id', auth()->id())
        ->where('reason', 'daily_income')
        ->whereDate('created_at', Carbon::today())
        ->sum('amount');

    $todayLevelCommission1 = UserLedger::where('user_id', auth()->id())
        ->where('reason', 'commission')
        ->where('step', 'first')
        ->whereDate('created_at', Carbon::today())
        ->sum('amount');

    $todayLevelCommission2 = UserLedger::where('user_id', auth()->id())
        ->where('reason', 'commission')
        ->where('step', 'second')
        ->whereDate('created_at', Carbon::today())
        ->sum('amount');

    $todayLevelCommission3 = UserLedger::where('user_id', auth()->id())
        ->where('reason', 'commission')
        ->where('step', 'third')
        ->whereDate('created_at', Carbon::today())
        ->sum('amount');

    $todayIncome = $todayDailyIncome + $todayLevelCommission1 + $todayLevelCommission2 + $todayLevelCommission3;

    return view('app.main.profile', compact(
        'first_level_users',
        'second_level_users',
        'third_level_users',
        'team_size',
        'lvTotalDeposit',
        'lvTotalWithdraw',
        'lv1Recharge',
        'lv2Recharge',
        'lv3Recharge',
        'lv1Withdraw',
        'lv2Withdraw',
        'lv3Withdraw',
        'activeMembers1',
        'activeMembers2',
        'activeMembers3',
        'totalInvestment',
        'levelTotalCommission1',
        'levelTotalCommission2',
        'levelTotalCommission3',
        'totalLevelInvest1',
        'totalLevelInvest2',
        'totalLevelInvest3',
        'todayIncome'  // Pass today's income to the view
    ));


        return view('app.main.profile');
    }

    public function team()
    {
        return view('app.main.team.index');
    }


    public function setting()
    {
        return view('app.main.mine.setting');
    }

    public function recharge()
    {
        return view('app.main.deposit.index');
    }

    public function recharge_amount($amount)
    {
        return view('app.main.deposit.recharge_confirm', compact('amount'));
    }

    public function payment_confirm($amount, $method, PaymentServices $payment)
    {

        $setting = Setting::first();

        $payment_method = PaymentMethod::where(['tag' => $method, 'status' => 'active'])->inRandomOrder()->first();
        if (!$payment_method){
            return back()->with('error', 'Method not available.');
        }

        // Verify if Recharge Allowed
        if ($setting->open_deposit != 1) {
            return redirect()->back()->with('error', "You can't Recharge your wallet now, Service not available. Try again later.");
        }

        $jsonData = '';
        $linkData = '';
        $reference = rand(00000,99999);

        // Auto Deposit
        if($payment_method->auto && $setting->auto_deposit) {
            // Charge Payment
            $chargePayment = $payment->charge($reference, 'NGN', $amount, $payment_method->tag);

            // Exception
            if($chargePayment['status'] == false) {
                return back()->with("error", $chargePayment['message']);
            }

            $jsonData = json_encode([
                'reference' => $chargePayment['data']['reference'],
                'order_ref' => $chargePayment['data']['order_ref']
            ]);
            
            $linkData = $chargePayment['data']['link'];

            $model = new Deposit();
            $model->user_id = Auth::id();
            $model->method_name = $payment_method->name;
            $model->order_id = $reference;
            $model->transaction_id = $chargePayment['data']['order_ref'];
            $model->amount = $amount;
            $model->final_amount = $amount;
            $model->pay_link = $linkData;
            $model->data = $jsonData;
            $model->date = date('d-m-Y H:i:s');
            $model->status = 'pending';
            $model->save();

            return redirect()->away($linkData);
        }


        return view('app.main.deposit.payment-confirm', compact('amount', 'payment_method'));
    }

    public function depositSubmit(Request $request)
    {
        $validate = Validator::make($request->all(), [
            //'acc_acount' => 'required',
            'amount' => 'required',
            //'payment_method' => 'required',
            //'transaction_id' => 'required',
            //'photo' => 'required',
        ]);

        if ($validate->fails()) {
            return back()->withErrors($validate->errors());
        }

        $model = new Deposit();
        $model->user_id = Auth::id();

        $path = uploadImage(false ,$request, 'photo', 'upload/payment/', 200, 200 ,$model->photo);
        $model->photo = $path ?? $model->photo;

        $model->method_name = $request->payment_method;
        $model->method_number = $request->acc_acount;
        $model->order_id = rand(00000,99999);
        $model->transaction_id = $request->transaction_id;
        $model->amount = $request->amount;
        $model->final_amount = $request->amount;
        $model->date = date('d-m-Y H:i:s');
        $model->status = 'pending';
        $model->save();
        return redirect()->route('user.deposit')->with('success', 'Successful');
    }

    public function update_profile(Request $request)
    {
        $user = User::find(Auth::id());
        $path = uploadImage(false, $request, 'photo', 'upload/profile/', 200, 200, $user->photo);
        $user->photo = $path ?? $user->photo;

        $user->update();
        return redirect()->route('my.profile')->with('success', 'Successful');
    }

    public function personal_details()
    {
        return view('app.main.update_personal_details');
    }

    public function card()
    {
        $methods = PaymentMethod::where('status', 'active')->where('id', '!=', 4)->get();

        return view('app.main.gateway_setup', compact('methods'));
    }

    public function setupGateway(Request $request)
    {
        $validate = Validator::make($request->all(), [
            'realname' => 'required',
            'gateway_method' => 'required',
            'gateway_number' => 'required',
        ]);

        if ($validate->fails()) {
            return redirect()->route('user.bank')->withErrors($validate->errors());
        }

        // Find Bank
        $bank = BankList::where('bank_code', $request->gateway_method)->first();

        // Not Exist
        if(!$bank) {
            //
            return redirect()->route('user.bank')->with('error', 'Selected Bank not found');
        }

        $user = User::find(Auth::id());

        $user->realname = $request->realname;
        $user->gateway_number = $request->gateway_number;
        $user->gateway_method = $request->gateway_method;
        $user->bank_name = $bank->name;
        $user->update();
        return redirect()->route('user.withdraw')->with('success', 'Successfully update account');
    }


    public function invite()
    {
        return view('app.main.invite');
    }

    public function level()
    {
        return view('app.main.level');
    }


    public function service()
    {
        return view('app.main.service');
    }


    public function appreview()
    {
        return view('app.main.appreview');
    }

    public function rule()
    {
        return view('app.main.rule');
    }

    public function partner()
    {
        return view('app.main.partner');
    }

    public function climRecord()
    {
        return view('app.main.climRecord');
    }

    public function add_bank()
    {
        return view('app.main.gateway_setup');
    }

    public function add_bank_create()
    {
        return view('app.main.add_bank_create');
    }

    public function setting_change_password(Request $request)
    {
        //Check current password
        $user = User::find(Auth::id());
        if (Hash::check($request->old_password, $user->password)) {
            if ($request->new_password == $request->confirm_password) {
                $user->password = Hash::make($request->new_password);
                $user->update();
                return redirect()->route('login_password')->with('success', 'Password changed');
            } else {
                return redirect()->route('login_password')->with('success', 'Password not match.');
            }
        } else {
            return redirect()->route('login_password')->with('success', 'Password not match');
        }
    }

    public function confirm_submit(Request $request)
    {
        $data = $request->all();
        $model = new Deposit();
        $model->user_id = $data['ui'];
        $model->method_name = $data['pm'];
        $model->method_number = '01000000000';
        $model->order_id = $data['oid'];
        $model->transaction_id = $data['tid'];
        $model->number = $data['aca'];
        $model->amount = $data['amount'];
        $model->final_amount = $data['amount'];
        $model->usdt = $data['amount'] / setting('rate');
        $model->date = Carbon::now();
        $model->status = 'pending';
        $model->save();
        return response()->json(['status' => true, 'data' => $data]);
    }
    
    public function showOrdered()
{
    // Get the authenticated user
    $user = auth()->user();
    
    // Calculate total income for entries with reason 'daily_income'
    $totalIncome = UserLedger::where('user_id', $user->id)
        ->where('reason', 'daily_income') // Filter by reason
        ->sum('amount');

    // Return the view with the calculated total income
    return view('app.main.ordered', compact('totalIncome', 'user'));
}

    

    public function download_apk()
    {
        $file = public_path('agri.apk');
        return response()->file($file, [
            'Content-Type' => 'application/vnd.android.package-archive',
            'Content-Disposition' => 'attachment; filename="agri.apk"',
        ]);
    }

}







