<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
  protected $fillable = [
        'name',
        'email',
        'password',
        'ref_id',
        'phone_code',
        'phone',
        'ref_by',
        'username',
        'code',
        'ip',
        'deposit_wallet',
        'balance',
        'register_bonus',
        'withdraw_password',
        'ifsc_code',
        'total_income',
        'today_income', 
        'bank_name', 
        'lv1_team',
        'lv2_team',
        'lv3_team',
        'total_team', 
        'team_income',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
    
    public function referrer()
{
    return $this->belongsTo(User::class, 'ref_by', 'ref_id');
}

public function checkIns()
{
    return $this->hasMany(CheckIn::class);
}

public function currentStreak()
{
    return $this->checkIns()->whereDate('created_at', '>=', now()->subDays(6))->count();
}

public function checkInToday()
{
    return $this->checkIns()->whereDate('created_at', today())->exists();
}

public function dailyRewards()
{
    return [10, 25, 50, 75, 100, 150, 300];
}
public function purchases()
{
    return $this->hasMany(Purchase::class);
}

public function deposits()
    {
        return $this->hasMany(Deposit::class);
    }

}
