<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserCheckIn extends Model
{
    use HasFactory;

    protected $table = 'user_check_ins'; // Specify the table name

    protected $fillable = [
        'user_id',
        'reward',
        'created_at',
        'updated_at',
    ];

    /**
     * Get the user that owns the check-in.
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
