<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserLedger extends Model
{
    use HasFactory;

    // Specify the fields that can be mass assigned
    protected $fillable = [
        'user_id',     // Allow mass assignment for user_id
        'reason',      // Reason for the transaction
        'amount',      // Total amount of the transaction
        'credit',      // Amount credited
        'debit',       // Amount debited
        'status',      // Status of the transaction
        'date',        // Date of the transaction
        'created_at',  // Timestamp of creation
        'claimed',     // claimed
        'updated_at',  // Timestamp of last update
    ];

    // Optionally, define the relationship with User if needed
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
