@extends('admin.partials.master')

@section('admin_content')
<section id="dashboard-ecommerce">
    <div class="row">
        <div class="col-sm-12">
            <div class="card shadow-sm">
                <div class="card-header pb-0">
                    <h4 class="card-title">
                        <div class="d-flex justify-content-between align-items-center">
                            <span>📦 Package Lists</span>
                            <a href="{{ route('admin.package.create') }}" class="btn btn-primary btn-sm">
                                <i class="bx bx-plus"></i> Add New Item
                            </a>
                        </div>
                    </h4>
                </div>

                <div class="card-body card-dashboard">
                    <div class="table-responsive">
                        <table class="table table-striped dataex-html5-selectors">
                            <thead class="thead-dark">
                                <tr>
                                    <th>#</th>
                                    <th>Name</th>
                                    <th>Photo</th>
                                    <th>Price</th>
                                    <th>Validity</th>
                                    <th>Buy Limit</th>
                                    <th>Status</th>
                                    <th>Type</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                            @foreach($packages as $key => $row)
                                <tr>
                                    <td>{{ $key + 1 }}</td>
                                    <td>{{ $row->name }}</td>
                                    <td>
                                        <img src="{{ asset(view_image($row->photo)) }}" alt="Package Photo" width="40" class="img-thumbnail">
                                    </td>
                                    <td>₦{{ number_format($row->price, 2) }}</td>
                                    <td>{{ $row->validity }} Days</td>
                                    <td>{{ $row->buy_limit ?? 'Unlimited' }}</td>
                                    <td>
                                        @if($row->status === 'active')
                                            <span class="badge badge-success">Active</span>
                                        @else
                                            <span class="badge badge-secondary">Inactive</span>
                                        @endif
                                    </td>
                                    <td>{{ ucfirst($row->type) }}</td>
                                    <td>
                                        <a href="{{ route('admin.package.view', $row->id) }}"
                                           class="btn btn-info btn-sm" data-toggle="tooltip" title="View">
                                            <i class="bx bx-show"></i>
                                        </a>

                                        <a href="{{ route('admin.package.create', $row->id) }}"
                                           class="btn btn-warning btn-sm" data-toggle="tooltip" title="Edit">
                                            <i class="bx bx-edit-alt"></i>
                                        </a>

                                        @if($row->id != 1)
                                            <form method="POST" action="{{ route('admin.package.delete', $row->id) }}" class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit"
                                                    class="btn btn-danger btn-sm"
                                                    onclick="return confirm('Are you sure you want to delete this package?')"
                                                    data-toggle="tooltip" title="Delete">
                                                    <i class="bx bx-trash"></i>
                                                </button>
                                            </form>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div> <!-- .table-responsive -->
                </div> <!-- .card-body -->
            </div>
        </div>
    </div>
</section>
@endsection
