@extends('admin.partials.master')

@section('admin_content')
    <section id="dashboard-ecommerce">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0">
                        <h4 class="card-title">
                            <div class="d-flex justify-content-between">
                                <div>Service Lists</div>
                                <div><a href="{{ route('admin.service.create') }}" class="btn btn-primary btn-sm"> <i class="bx bx-plus"></i> Add New Service </a> </div>
                            </div>
                        </h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>S.N</th>
                                            <th>Name</th>
                                            <th>Platform</th>
                                            <th>Link</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($services as $service)
                                            <tr>
                                                <td>{{ $service->id }}</td>
                                                <td>{{ $service->name }}</td>
                                                <td>{{ ucfirst($service->platform) }}</td>
                                                <td>
                                                    <a href="{{ $service->link }}" target="_blank">{{ $service->link }}</a>
                                                </td>
                                                <td>
                                                    <a href="{{ route('admin.service.edit', $service->id) }}" class="btn btn-warning btn-sm">Edit</a>
                                                    <form action="{{ route('admin.service.destroy', $service->id) }}" method="POST" style="display:inline;">
                                                        
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
