<!-- SweetAlert2 Toast Notifications -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
  const Toast = Swal.mixin({
    toast: true,
    position: 'center', // 🔁 changed from 'top-end'
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true
  });

  document.addEventListener("DOMContentLoaded", function () {
    @if ($errors->any())
      @foreach ($errors->all() as $error)
        Toast.fire({
          icon: 'error',
          title: @json($error)
        });
      @endforeach
    @endif

    @if (session('success'))
      Toast.fire({
        icon: 'success',
        title: @json(session('success'))
      });
    @endif

    @if (session('error'))
      Toast.fire({
        icon: 'error',
        title: @json(session('error'))
      });
    @endif

    @if (session('message'))
      Toast.fire({
        icon: 'info',
        title: @json(session('message'))
      });
    @endif
  });
</script>
