<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Connexion</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/layui@2.8.17/dist/css/layui.css" />
  <style>
    :root {
      --primary: #55b432;
      --primary-dark: #409425;
      --gray: #888;
      --white: #fff;
    }
    body {
      margin: 0;
      font-family: 'Segoe UI', sans-serif;
      background-color: var(--primary);
      color: var(--gray);
    }
    .container {
      max-width: 420px;
      margin: 40px auto;
      background-color: var(--white);
      border-radius: 32px 32px 0 0;
      padding: 24px;
    }
    .logo {
      text-align: center;
      margin-top: -20px;
    }
    .logo img {
      height: 60px;
      margin-bottom: 10px;
    }
    .tab-switch {
      display: flex;
      justify-content: space-around;
      border-radius: 32px 32px 0 0;
      background: var(--primary-dark);
    }
    .tab-switch div {
      flex: 1;
      text-align: center;
      padding: 14px 0;
      font-weight: bold;
      color: white;
      cursor: pointer;
      border-bottom: 3px solid transparent;
    }
    .tab-switch .active {
      background-color: var(--white);
      color: var(--primary);
      border-bottom: 3px solid var(--primary);
      border-radius: 32px 32px 0 0;
    }
    .form-title {
      text-align: center;
      font-size: 22px;
      font-weight: bold;
      color: var(--primary);
      margin: 20px 0;
    }
    .input-group {
      margin-bottom: 18px;
      position: relative;
    }
    .input-label {
      font-size: 14px;
      margin-bottom: 6px;
      display: block;
      color: #555;
    }
    .layui-input {
      width: 100%;
      height: 42px;
      border-radius: 12px;
      padding: 0 12px;
    }
    .show-password {
      position: absolute;
      right: 12px;
      top: 34px;
      cursor: pointer;
      font-size: 16px;
      color: #aaa;
    }
    .submit-btn {
      background-color: var(--primary);
      color: white;
      width: 100%;
      padding: 12px;
      border: none;
      border-radius: 50px;
      font-weight: bold;
      margin-top: 12px;
      font-size: 16px;
      cursor: pointer;
      transition: background 0.2s ease;
    }
    .submit-btn:hover {
      background-color: var(--primary-dark);
    }
  </style>
</head>
<body>
  <div class="container">
    <div class="logo">
      <img src="{{ asset('public/static/img/logo.b086b4ea.png') }}" alt="Logo" />
    </div>
    <div class="tab-switch">
      <div onclick="location.href='/register'">S'inscrire</div>
      <div class="active">Connexion</div>
    </div>
    <div class="form-title">Connexion_{{ env('APP_NAME') }}</div>
    <form id="loginForm" class="layui-form" method="POST" action="{{ url('login') }}">
      @csrf
      @include('alert-message')
      <div class="input-group">
        <label class="input-label">Numéro de téléphone portable</label>
        <input type="tel" name="phone" placeholder="Veuillez entrer votre téléphone" class="layui-input" required />
      </div>
      <div class="input-group">
        <label class="input-label">Mot de passe</label>
        <input type="password" name="password" id="passwordInput" placeholder="Veuillez entrer le mot de passe" class="layui-input" required />
        <span class="show-password" onclick="togglePassword()">👁️</span>
      </div>
      <button type="submit" class="submit-btn">Se connecter</button>
    </form>
  </div>
  <script>
    function togglePassword() {
      const input = document.getElementById('passwordInput');
      input.type = input.type === 'password' ? 'text' : 'password';
    }
  </script>
</body>
</html>
