<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Inscription</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/layui@2.8.17/dist/css/layui.css" />
  <style>
    :root {
      --primary: #55b432;
      --primary-dark: #409425;
      --gray: #888;
      --white: #fff;
    }
    body {
      margin: 0;
      font-family: 'Segoe UI', sans-serif;
      background-color: var(--primary);
      color: var(--gray);
    }
    .container {
      max-width: 420px;
      margin: 40px auto;
      background-color: var(--white);
      border-radius: 32px 32px 0 0;
      padding: 24px;
    }
    .logo {
      text-align: center;
      margin-top: -20px;
    }
    .logo img {
      height: 60px;
      margin-bottom: 10px;
    }
    .tab-switch {
      display: flex;
      justify-content: space-around;
      border-radius: 32px 32px 0 0;
      background: var(--primary-dark);
    }
    .tab-switch div {
      flex: 1;
      text-align: center;
      padding: 14px 0;
      font-weight: bold;
      color: white;
      cursor: pointer;
      border-bottom: 3px solid transparent;
    }
    .tab-switch .active {
      background-color: var(--white);
      color: var(--primary);
      border-bottom: 3px solid var(--primary);
      border-radius: 32px 32px 0 0;
    }
    .form-title {
      text-align: center;
      font-size: 22px;
      font-weight: bold;
      color: var(--primary);
      margin: 20px 0;
    }
    .input-group {
      margin-bottom: 18px;
      position: relative;
    }
    .input-label {
      font-size: 14px;
      margin-bottom: 6px;
      display: block;
      color: #555;
    }
    .layui-input {
      width: 100%;
      height: 42px;
      border-radius: 12px;
      padding: 0 12px;
    }
    .phone-group {
      display: flex;
    }
    .phone-code {
      min-width: 80px;
      padding: 0 12px;
      background-color: #f2f2f2;
      border-radius: 12px 0 0 12px;
      display: flex;
      align-items: center;
      justify-content: center;
      color: var(--primary);
      font-weight: bold;
      border: 1px solid #ddd;
    }
    .phone-input {
      flex: 1;
      border-radius: 0 12px 12px 0;
      border-left: none;
    }
    .captcha-group {
      display: flex;
    }
    .captcha-input {
      flex: 1;
      border-radius: 12px 0 0 12px;
    }
    .captcha-img {
      width: 100px;
      height: 42px;
      background-color: #f0f0f0;
      border: 1px solid var(--primary);
      border-left: none;
      border-radius: 0 12px 12px 0;
      cursor: pointer;
      background-size: cover;
      background-repeat: no-repeat;
      background-position: center;
    }
    .submit-btn {
      background-color: var(--primary);
      color: white;
      width: 100%;
      padding: 12px;
      border: none;
      border-radius: 50px;
      font-weight: bold;
      margin-top: 12px;
      font-size: 16px;
      cursor: pointer;
      transition: background 0.2s ease;
    }
    .submit-btn:hover {
      background-color: var(--primary-dark);
    }
    .show-password {
      position: absolute;
      right: 12px;
      top: 34px;
      cursor: pointer;
      font-size: 16px;
      color: #aaa;
    }
    .error-text {
      color: red;
      font-size: 13px;
      margin-bottom: 8px;
    }
  </style>
</head>
<body>
  <div class="container">
    <div class="logo">
      <img src="{{ asset('public/static/img/logo.b086b4ea.png') }}" alt="Logo" />
    </div>
    <div class="tab-switch">
      <div class="active" onclick="switchTab('register')">Inscription</div>
      <div onclick="location.href='/login'">Connexion</div>
    </div>
    <div class="form-title">Inscription_{{ env('APP_NAME') }}</div>
    <form id="registerForm" class="layui-form" method="post" action="{{ url('register') }}">
      @csrf
      @include('alert-message')
      <div class="input-group">
        <label class="input-label">Numéro de téléphone portable</label>
        <div class="phone-group">
          <div class="phone-code">+27</div>
          <input type="tel" name="phone" placeholder="Veuillez entrer votre téléphone" class="layui-input phone-input" required />
        </div>
      </div>
      <div class="input-group">
        <label class="input-label">Mot de passe</label>
        <input type="password" name="password" id="passwordInput" placeholder="Veuillez entrer le mot de passe" class="layui-input" required />
        <span class="show-password" onclick="togglePassword()">👁️</span>
      </div>
      <div class="input-group">
        <label class="input-label">Code d'invitation</label>
        <input type="text" name="ref_by" value="{{isset($ref_by) && !empty($ref_by) && $ref_by != null ? $ref_by : ''}}" class="layui-input" />
      </div>
      <div class="input-group">
        <label class="input-label">Code de vérification</label>
        <div class="captcha-group">
          <input type="text" name="captcha" placeholder="Entrez le code" class="layui-input captcha-input" required />
          <div class="captcha-img" onclick="refreshCaptcha()" id="captchaBox"
               style="background-image: url('{{ captcha_src('custom') }}');"></div>
        </div>
      </div>
      <button type="submit" class="submit-btn">S'inscrire maintenant</button>
    </form>
  </div>
  <script src="https://cdn.jsdelivr.net/npm/layui@2.8.17/dist/layui.js"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    function refreshCaptcha() {
      const box = document.getElementById('captchaBox');
      const newUrl = "{{ captcha_src('custom') }}?t=" + Date.now();
      box.style.backgroundImage = `url('${newUrl}')`;
    }
    function togglePassword() {
      const input = document.getElementById('passwordInput');
      input.type = input.type === 'password' ? 'text' : 'password';
    }
    function switchTab(tab) {
      // Logique de changement d'onglet si nécessaire
    }
  </script>
</body>
</html>
