<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Temporarily Closed</title>
    <style>
        /* Global Styles */
        body {
            margin: 0;
            padding: 0;
            font-family: 'Roboto', Arial, sans-serif;
            background: linear-gradient(135deg, #55c132, #55b432);
            color: #ffffff;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            text-align: center;
        }

        .container {
            width: 90%;
            max-width: 500px;
            padding: 20px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 15px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.3);
        }

        /* Typography */
        h1 {
            font-size: 2.5rem;
            margin-bottom: 10px;
        }

        p {
            font-size: 1.2rem;
            margin-bottom: 20px;
            line-height: 1.5;
        }

        /* Timer Styles */
        .timer {
            font-size: 2rem;
            font-weight: bold;
            letter-spacing: 1px;
            padding: 10px 20px;
            border: 2px solid rgba(255, 255, 255, 0.5);
            border-radius: 10px;
            background: rgba(0, 0, 0, 0.2);
            display: inline-block;
            margin-bottom: 20px;
        }

        /* Footer */
        footer {
            margin-top: 15px;
            font-size: 0.9rem;
            opacity: 0.8;
        }

        /* Responsive Design */
        @media (max-width: 480px) {
            h1 {
                font-size: 2rem;
            }
            p {
                font-size: 1rem;
            }
            .timer {
                font-size: 1.5rem;
                padding: 8px 15px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>User Login Available</h1>
        <p>
            User Login is currently unavailable due to heavy load. 
            It will reopen on November 27, 2024, at 10:00 AM:
        </p>
        <div class="timer" id="countdown">Loading...</div>
        <footer>
            Thank you for your patience! Please return later.
        </footer>
    </div>

    <script>
        // Timer Logic
        const countdownElement = document.getElementById("countdown");
        const targetTime = new Date("2024-11-27T10:00:00").getTime(); // Set specific date and time

        function updateTimer() {
            const now = new Date().getTime();
            const distance = targetTime - now;

            if (distance < 0) {
                countdownElement.innerText = "Registration is now open!";
                return;
            }

            const days = Math.floor(distance / (1000 * 60 * 60 * 24));
            const hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            const minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            const seconds = Math.floor((distance % (1000 * 60)) / 1000);

            countdownElement.innerText = `${days}d ${hours.toString().padStart(2, '0')}h ${minutes.toString().padStart(2, '0')}m ${seconds.toString().padStart(2, '0')}s`;
        }

        setInterval(updateTimer, 1000);
        updateTimer(); // Initialize timer display
    </script>
</body>
</html>
