<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Check In</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-image: url('/public/images/checkin.jpg');
            background-size: cover;
            background-position: center;
            margin: 0;
            padding: 0;
            height: 70vh;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .container {
            position: relative;
            background-color: #3d2e2b;
            border: 5px solid #f0b850;
            border-radius: 15px;
            padding: 50px 20px 30px;
            width: 90%;
            text-align: center;
            color: white;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.4);
        }
        .title-banner {
            position: absolute;
            top: -30px;
            left: 50%;
            transform: translateX(-50%);
            background-color: #922726;
            color: #f0b850;
            font-size: 2em;
            font-weight: bold;
            padding: 5px 20px;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.3);
        }
        .countdown {
            margin-bottom: 15px;
            font-size: 1em;
            color: #f0b850;
        }
        .button {
            width: 80px;
            height: 100px;
            margin: 5px;
            font-size: 1em;
            background-color: #4b2b2b;
            border: 3px solid #f0b850;
            border-radius: 10px;
            color: white;
            cursor: pointer;
            transition: background-color 0.3s;
            position: relative;
            display: inline-block;
        }
        .button span {
            display: block;
            margin-top: 10px;
        }
        .button:hover {
            background-color: #73422a;
        }
        .button.disabled {
            background-color: #666;
            border-color: #888;
            cursor: not-allowed;
        }
        .button.unavailable {
            background-color: #922726;
            cursor: not-allowed;
        }
        #checkInButtons {
            display: flex;
            justify-content: center;
            flex-wrap: wrap;
            gap: 10px;
        }
        .reward-item {
            font-size: 0.9em;
            margin-top: 5px;
            color: #f0b850;
        }
        @media (max-width: 600px) {
            .container {
                padding: 40px 10px 20px;
            }
            .title-banner {
                font-size: 1.4em;
                padding: 4px 15px;
                top: -25px;
            }
            .button {
                width: 75px;
                height: 85px;
                font-size: 0.9em;
            }
            .button .reward-item {
                font-size: 0.8em;
            }
        }
        @media (max-width: 400px) {
            .title-banner {
                font-size: 1.3em;
                padding: 3px 10px;
                top: -20px;
            }
            .button {
                width: 60px;
                height: 70px;
                font-size: 0.8em;
            }
            .reward-item {
                font-size: 0.7em;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="title-banner">RECOMPENSE QUOTIDIENNE</div>
        <div class="countdown" id="countdownTimer"></div>
        <div id="checkInButtons">
            @php
                use Carbon\Carbon;
                $today = Carbon::today();
                $registered = \Carbon\Carbon::parse(auth()->user()->created_at)->startOfDay();
                $daysSinceRegister = $registered->diffInDays($today);
                $startOfUserWeek = $registered->copy()->addDays(floor($daysSinceRegister / 7) * 7);
                $todayIndex = $today->diffInDays($startOfUserWeek);
            @endphp
            @for ($day = 0; $day < 7; $day++)
                @php
                    $claimed = isset($claimedDays[$day]);
                    $isAvailable = ($day === $todayIndex);
                    $rewardAmount = $rewards[$day];
                @endphp
                <button class="button {{ $claimed ? 'disabled' : (!$isAvailable ? 'unavailable' : '') }}"
                        onclick="{{ !$claimed && $isAvailable ? 'checkIn(' . ($day + 1) . ')' : '' }}"
                        {{ $claimed || !$isAvailable ? 'disabled' : '' }}>
                    <div>Jour {{ $day + 1 }}</div>
                    <div class="reward-item">{{ $rewardAmount }} R</div>
                    @if ($claimed)
                        <span>✅</span>
                    @endif
                </button>
            @endfor
        </div>
    </div>
    @include('alert-message')
    @include('alert-message')
    <script>
        function checkIn(day) {
            fetch('/check-in', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify({ day: day })
            })
            .then(response => {
                if (!response.ok) {
                    return response.json().then(err => {
                        throw new Error(err.message || 'Quelque chose a mal tourne');
                    });
                }
                return response.json();
            })
            .then(data => {
                alert(data.message);
                location.reload();
            })
            .catch(error => {
                alert('Erreur: ' + error.message);
            });
        }

        function updateCountdown() {
            const now = new Date();
            const midnight = new Date();
            midnight.setHours(24, 0, 0, 0);
            const diff = midnight - now;
            if (diff <= 0) {
                document.getElementById('countdownTimer').textContent = "Nouveau check-in disponible bientot...";
                return;
            }
            const hours = Math.floor(diff / (1000 * 60 * 60));
            const minutes = Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60));
            const seconds = Math.floor((diff % (1000 * 60)) / 1000);
            document.getElementById('countdownTimer').textContent =
                `Prochain check-in dans: ${hours.toString().padStart(2, '0')}h ${minutes.toString().padStart(2, '0')}m ${seconds.toString().padStart(2, '0')}s`;
        }
        setInterval(updateCountdown, 1000);
        updateCountdown();
    </script>
</body>
</html>
