<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8"/>
  <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>waf-farm | Recharge</title>
  <link rel="stylesheet" href="/static/reset.css"/>
  <link rel="stylesheet" href="/static/style.css"/>
  <link rel="stylesheet" href="/static/layui.css"/>
  <script src="/static/jquery-3.5.1.min.js"></script>
  <script src="/static/layui.js"></script>
  <style>
    .amount-options {
      display: flex;
      gap: 10px;
      flex-wrap: wrap;
      margin-top: 10px;
    }
    .amount-option {
      flex: 1 0 30%;
      padding: 12px 0;
      text-align: center;
      background: #fff;
      border: 2px solid #ccc;
      border-radius: 6px;
      cursor: pointer;
      font-weight: 600;
    }
    .amount-option.active {
      border-color: #55b432;
      background: #fff;
      color: #55b432;
    }
  </style>
</head>
<body class="huiBg">
<div class="top">
  <a href="{{ route('dashboard') }}" class="topLeft">
    <i class="layui-icon layui-icon-left"></i>
  </a>
  <div class="topTit">Recharge</div>
</div>
<div class="wallet-box">
  <div class="balance-list">
    <div class="balance-item">
      <h3>{{ price(auth()->user()->deposit_wallet) }}</h3>
      <p>Solde du portefeuille</p>
    </div>
  </div>
  <div class="wallet-item">
    <h3>Montant de recharge</h3>
    <div class="wallet-input">
      <input id="amount" type="number" name="amount" placeholder="Veuillez entrer le montant de recharge" value="">
      <i>{{ currency() }}</i>
    </div>
    <div class="amount-options">
      <div class="amount-option" onclick="selectAmount(200)">200 R</div>
      <div class="amount-option" onclick="selectAmount(500)">500 R</div>
      <div class="amount-option" onclick="selectAmount(1000)">1000 R</div>
      <div class="amount-option" onclick="selectAmount(2000)">2000 R</div>
      <div class="amount-option" onclick="selectAmount(3000)">3000 R</div>
      <div class="amount-option" onclick="selectAmount(5000)">5000 R</div>
    </div>
  </div>
  <div class="wallet-item">
    <h3>Canal de recharge</h3>
    <div class="wallet-channel">
      @php
        $paymentMethods = \App\Models\PaymentMethod::where('status', 'active')->get();
      @endphp
      @foreach($paymentMethods as $element)
        <div class="wallet-channel-item" data-id="{{ $element->tag }}" onclick="selectMethod('{{ $element->tag }}', '{{ $element->name }}')">
          {{ $element->name }}
          <i class="layui-icon layui-icon-ok"></i>
        </div>
      @endforeach
    </div>
  </div>
  <button type="button" class="wallet-btn" onclick="go_payment()">Recharger</button>
  <div class="wallet-rule">
    <p><strong>1. Le montant minimum de recharge est de 200 R.</strong></p>
    <p><strong>2. Il est interdit d'enregistrer d'anciens comptes de paiement.</strong></p>
    <p><strong>3. Si le paiement n'est pas reçu dans les 30 minutes, veuillez contacter le support.</strong></p>
  </div>
</div>
<div id="snackbar"></div>
@include('alert-message')
<form id="rechargeForm" method="POST" style="display:none;">
  <input type="hidden" name="amount">
  <input type="hidden" name="userPhone">
</form>
<script>
  let selectedPaymentMethod = null;
  function selectMethod(selected_method_tag, selectMethodName) {
    const methodItems = document.querySelectorAll('.wallet-channel-item');
    methodItems.forEach(item => item.classList.remove('active'));
    const selectedItem = document.querySelector(`.wallet-channel-item[data-id="${selected_method_tag}"]`);
    if (selectedItem) {
      selectedItem.classList.add('active');
    }
    selectedPaymentMethod = { tag: selected_method_tag, name: selectMethodName };
  }
  function selectAmount(value) {
    const input = document.getElementById('amount');
    input.value = value;
    const buttons = document.querySelectorAll('.amount-option');
    buttons.forEach(btn => btn.classList.remove('active'));
    event.target.classList.add('active');
  }
  function go_payment() {
    const amount = document.getElementById('amount').value;
    if (!selectedPaymentMethod) {
      message('Veuillez sélectionner une méthode de paiement');
      return;
    }
    if (!amount || isNaN(amount) || parseFloat(amount) < 200) {
      message('Veuillez entrer un montant valide (minimum 200 R)');
      return;
    }
    window.location.href = `{{ url('user/payment') }}/${amount}/${selectedPaymentMethod.tag}`;
  }
  document.addEventListener('DOMContentLoaded', () => {
    const firstMethod = document.querySelector('.wallet-channel-item');
    if (firstMethod) {
      const firstMethodTag = firstMethod.getAttribute('data-id');
      const firstMethodName = firstMethod.textContent.trim();
      selectMethod(firstMethodTag, firstMethodName);
    }
  });
</script>
</body>
</html>
