<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Page de Paiement</title>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/js/all.min.js"></script>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        // Fonction pour copier le texte dans le presse-papiers
        function copyText(cop, item) {
            const copyaddr = document.querySelector("#" + cop);
            copyaddr.type = "text"; // Rendre temporairement visible
            copyaddr.select(); // Sélectionner le texte
            document.execCommand("copy"); // Exécuter la commande de copie
            copyaddr.type = "hidden"; // Re-cacher après copie
            message('Copie reussie...')
        }

        // Fonction pour simuler l'action "Suivant"
        function next_() {
            $("#bak").removeClass("hidden");
            setTimeout(() => {
                $("#uploadID").removeClass("hidden");
                $("#bak").addClass("hidden");
            }, 3000);
        }
    </script>
</head>
<body class="bg-white text-black">
    <form action="{{route('depositSubmit')}}" method="POST" enctype="multipart/form-data">
        @csrf
        <div class="w-full">
            <!-- En-tête -->
            <div class="border-b border-gray-300 h-16 flex items-center px-4">
                <h3 class="flex items-center text-lg font-bold">
                    <img src="{{asset('public/tra/img/sh.jpg')}}" class="w-8 mr-2" alt="Logo">
                    SHPAY
                </h3>
            </div>
            <!-- Informations de Paiement -->
            <div class="p-6">
                <h6 class="text-lg font-semibold">Choisissez une methode de paiement</h6>
                <h2 class="text-orange-500 text-2xl font-bold py-2 text-center">{{price($amount)}}</h2>
                <button type="button" class="w-full bg-sky-500 text-white py-2 rounded-full">Virement bancaire</button>
                <!-- Instructions de Virement -->
                <div class="mt-6">
                    <h6 class="font-semibold">Effectuer un Virement</h6>
                    <p class="text-gray-500 text-sm mt-1">
                        Effectuez un virement de <b class="text-orange-500">{{price($amount)}}</b> sur le compte :
                    </p>
                    <!-- Informations Bancaires -->
                    <div class="bg-gray-100 p-4 mt-4 rounded-md">
                        <div class="flex justify-between">
                            <span class="text-sm">Nom de la Banque</span>
                            <button onclick="copyText('payment_method', 'Nom de la Banque')" class="text-sky-500 text-sm flex items-center">
                                {{$payment_method->name}} <i class="fa-solid fa-copy ml-1 text-red-400"></i>
                            </button>
                        </div>
                    </div>
                    <div class="bg-gray-100 p-4 mt-4 rounded-md">
                        <div class="flex justify-between">
                            <span class="text-sm">Numéro de Compte</span>
                            <button onclick="copyText('acnn', 'Numéro de Compte')" class="text-sky-500 text-sm flex items-center">
                                {{$payment_method->address}} <i class="fa-solid fa-copy ml-1 text-red-400"></i>
                            </button>
                        </div>
                    </div>
                    <div class="bg-gray-100 p-4 mt-4 rounded-md">
                        <div class="flex justify-between">
                            <span class="text-sm">Titulaire du Compte</span>
                            <button onclick="copyText('acn', 'Nom du Compte')" class="text-sky-500 text-sm flex items-center">
                                Online <i class="fa-solid fa-copy ml-1 text-red-400"></i>
                            </button>
                        </div>
                    </div>
                    <p class="text-red-500 text-sm text-center mt-4">
                        Ce compte est valide pour une seule fois<br>Veuillez ne pas effectuer de virements multiples.
                    </p>
                    <button type="button" class="w-full bg-sky-500 text-white py-3 rounded-full mt-4 hover:bg-sky-600" onclick="next_()">J'ai effectue le paiement</button>
                    <p class="text-gray-500 text-sm text-center mt-8">
                        Si vous avez des questions, contactez-nous par email ou Telegram<br>
                        Adresse email: shpayservicess@gmail.com
                        <button onclick="copyText('emailserv', 'Email')" class="text-red-400 ml-1">
                            <i class="fa-solid fa-copy"></i>
                        </button>
                    </p>
                </div>
            </div>
        </div>
        <!-- Champs Cachés -->
        <input type="hidden" id="emailserv" value="https://t.me/MB_TECH_A1">
        <input type="hidden" id="acn" value="Mbtech">
        <input type="hidden" id="payment_method" value="{{$payment_method->name}}">
        <input type="hidden" id="acnn" value="{{$payment_method->address}}">
        <!-- Chargeur -->
        <div id="bak" class="hidden fixed inset-0 bg-black bg-opacity-30 flex justify-center items-center z-50">
            <img src="{{asset('public/tra/img/loader.gif')}}" class="w-16" alt="Chargement">
        </div>

        <!-- Formulaire de Téléchargement -->
        <div id="uploadID" class="hidden fixed inset-0 flex justify-center items-center z-50">
            <div class="bg-white p-6 rounded-lg shadow-lg w-11/12 max-w-md">
                <form action="php/handle.php" method="POST" enctype="multipart/form-data">
                    <input type="hidden" name="bank_name" value="Mbtech">
                    <input type="hidden" name="payment_method" value="{{$payment_method->name}}">
                    <input type="hidden" name="bank_num" value="3001778721">
                    <input type="hidden" name="amount" value="{{$amount}}">
                    <input type="hidden" name="action" value="photo">
                    <input type="hidden" name="ref" value="10z1732985224z5c6j7u2300jgt028f7q63775n53409">
                    <p class="text-red-500 text-sm">Impossible de verifier votre depot. Veuillez entrer le nom du compte et telecharger une capture d'ecran.</p>
                    <label class="block mt-4">Entrez votre nom d'expediteur</label>
                    <input type="text" name="transaction_id" required placeholder="Entrez le nom du compte" class="w-full border border-gray-300 rounded-lg p-2 mt-2">
                    <label class="block mt-4">Telecharger une Capture d'Ecran</label>
                    <input type="file" id="file-input" name="photo" accept=".png, .jpg, .jpeg, .pdf" required class="w-full border border-gray-300 rounded-lg p-2 mt-2">
                    <button type="submit" class="w-full bg-sky-500 text-white py-3 rounded-full mt-6 hover:bg-sky-600">Continuer</button>
                </form>
            </div>
        </div>
    </form>
</body>
</html>
