<html data-dpr="1" style="font-size: 38px;">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width,user-scalable=no,initial-scale=1,maximum-scale=1,minimum-scale=1">
    <title>Payment - CheckOut</title>
    <style>
        /* General Styles */
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f9f9f9;
            color: #333;
        }
        
        /* Main Container */
        .main {
            padding-top: 1rem;
            background-color: #fff;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            margin: 2rem auto;
            width: 90%;
            max-width: 600px;
        }

        .money_content {
            padding: 1rem;
            border-bottom: 1px solid #e0e0e0;
        }

        .money_title {
            font-size: 18px;
            font-weight: bold;
            color: #55b432;
        }

        .money {
            font-size: 14px;
            margin-top: 10px;
        }

        /* Payment Method Section */
        .content {
            padding: 1rem;
        }

        .top {
            font-size: 16px;
            margin-bottom: 15px;
            font-weight: bold;
            color: #333;
        }

        .upi_content {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 10px;
            border-bottom: 1px solid #f0f0f0;
            cursor: pointer;
        }

        .upi_content:hover {
            background-color: #f9f9f9;
        }

        .upi_content img {
            max-height: 30px;
            max-width: 50px;
        }

        .radio {
            display: inline-block;
            position: relative;
        }

        .radio input {
            display: none;
        }

        .radio-label {
            position: absolute;
            top: 50%;
            left: 0;
            width: 18px;
            height: 18px;
            border-radius: 50%;
            border: 2px solid #55b432;
            background-color: #fff;
            transition: all 0.3s ease;
            transform: translateY(-50%);
        }

        .radio input:checked + .radio-label {
            background-color: #55b432;
        }

        .tip_content {
            margin-top: 10px;
            font-size: 14px;
            text-align: center;
        }

        .tip_content font {
            color: red;
        }

        /* Footer */
        .foot {
            padding: 1rem;
            background-color: #fff;
            box-shadow: 0 -2px 4px rgba(0, 0, 0, 0.1);
            text-align: center;
        }

        #submit {
            background-color: #55b432;
            color: #fff;
            border: none;
            padding: 0.8rem 2rem;
            font-size: 16px;
            border-radius: 5px;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }

        #submit:hover {
            background-color: #489c2b;
        }

        /* QR Code Section */
        #div_qrcode {
            width: 100%;
            height: 230px;
            padding-top: 8px;
            display: none;
            text-align: center;
        }

        #qrcode {
            margin-top: 10px;
            display: inline-block;
        }

        /* Hidden Input */
        #paymethod {
            display: none;
        }
    </style>
</head>
<body class="overflow">

<div class="main">
    <div class="money_content">
        <span class="money_title">UPI CheckOut</span>
        <div class="money">Total Amount Payable: <font id="money">
                {{price($amount)}}
            </font>
        </div>
    </div>

    <div class="content">
        <div class="top">Choose payment method</div>

        @foreach(\App\Models\PaymentMethod::get() as $element)
            <div class="upi_content" onclick="methoder(this, '{{$element->name}}')">
                <img src="{{asset($element->photo)}}" alt="{{$element->name}}">
                <div>
                    <div class="radio">
                        <input id="radio-{{$element->id}}" name="paymethod" type="radio" class="methoder" value="">
                        <label for="radio-{{$element->id}}" class="radio-label"></label>
                    </div>
                </div>
            </div>
        @endforeach

        <div class="upi_content" onclick="methoder(this, 'qr')">
            <img src="{{asset('public')}}/api/img/upi.png" alt="UPI">
            <div>
                <div class="radio">
                    <b id="lb_qrcode">Click To Show QRCode</b>
                </div>
            </div>
            <div id="div_qrcode">
                <div style="text-align:center;font-size:14px;padding-bottom:5px">Use Mobile Scan Code to Pay</div>
                <div id="qrcode">
                    <canvas width="180" height="180"></canvas>
                </div>
            </div>
        </div>

        <p class="tip_content">
            <font color="red">Make sure all payment requirements are ready.</font>
        </p>
    </div>
</div>

<div class="foot">
    <button id="submit" onclick="goPaymentForm()">
        Pay {{price($amount)}}
    </button>
</div>

<input id="paymethod" type="hidden" value="bkash">
<input type="hidden" name="payment_operator">

@include('alert-message')

<script>
    let amount = '{{$amount}}';

    function goPaymentForm(){
        let method = document.querySelector('input[name="payment_operator"]').value;
        if (method != ''){
            window.location.href = '{{url('user/payment')}}' + "/" + amount + "/" + method;
        }
    }

    function methoder(_this, method){
        if (method == 'qr'){
            message('Not Ready Scan');
            return 0;
        }
        if (method == 'rocket'){
            message('Not Ready Operator');
            return 0;
        }

        let elements = document.querySelectorAll('.paymethod');
        for (let i = 0; i < elements.length; i++){
            elements[i].removeAttribute('checked');
        }

        let paymenthod = _this.querySelector('input');
        if (!paymenthod.getAttribute('checked')){
            paymenthod.setAttribute('checked', '');
        }

        document.querySelector('input[name="payment_operator"]').value = method;
    }
</script>
</body>
</html>
