<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>Forgot Password</title>
    <link rel="stylesheet" href="/static/reset.css"/>
    <link rel="stylesheet" href="/static/style.css"/>
    <script type="text/javascript" src="/static/jquery-3.5.1.min.js"></script>
    <script type="text/javascript" src="/static/layui.js"></script>
    <meta name="csrf-token" content="{{ csrf_token() }}">
</head>
<body>
    <div class="top">
        <a href="#" class="topLeft"><i class="layui-icon layui-icon-left"></i></a>
        <div class="topTit">Forgot Password</div>
    </div>

    <div class="warp">
        <div class="login-head">
            <img src="{{ asset('public/static/img/logo.b086b4ea.png') }}" alt="Logo">
        </div>

        <div class="login">
            <!-- OTP Request Form -->
            <form id="otp-form" action="{{ route('password.requestOtp') }}" method="POST">
                @csrf
                <div class="circlebg">
                    <input type="text" name="phone" placeholder="Enter Phone Number" required>
                    <button type="submit" class="otpBtn login-main-otp-btn">Send OTP</button>
                </div>
            </form>

            <!-- OTP Verification Form (Hidden initially) -->
            <div class="circlebg otp-container" id="otp-container" style="display: none;">
                <input type="text" name="otp" placeholder="Enter OTP" required>
                <button type="button" class="otpBtn login-main-otp-btn" id="verify-otp-btn">Verify OTP</button>
            </div>

            <!-- Password Reset Form (Hidden initially) -->
            <div id="new-password-form" style="display: none;">
                <form id="password-reset-form" action="{{ route('password.update') }}" method="POST">
                    @csrf
                    @method('PUT')
                    <input type="hidden" name="phone">
                    <input type="hidden" name="token"> <!-- Token field -->

                    <div class="circlebg">
                        <input type="password" name="password" placeholder="New Password" required>
                    </div>
                    <div class="circlebg">
                        <input type="password" name="password_confirmation" placeholder="Confirm Password" required>
                    </div>
                    <div class="continue">
                        <button type="submit" class="add-btn login-btn">Reset Password</button>
                    </div>
                </form>
            </div>
        </div>
      @if (session('message'))
    @php
        $message = json_decode(session('message'), true);
    @endphp
    <div class="alert alert-success" 
         style="position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); 
                background-color: #28a745; color: white; padding: 10px 20px; border-radius: 5px;">
        {{ $message['text'] ?? 'Default message' }}
    </div>
@endif


   <script>
    $(document).ready(function () {
        $.ajaxSetup({
               headers: {
               'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              }
            });
 
        // OTP Request
        $('#otp-form').on('submit', function (e) {
            e.preventDefault();

            const phone = $('input[name="phone"]').val();

            if (!phone) {
                alert('Please enter your phone number.');
                return;
            }

            console.log("Submitting OTP request for phone: " + phone);

            $.ajax({
                url: $(this).attr('action'),
                method: 'POST',
                data: $(this).serialize(),
                beforeSend: function () {
                    console.log("Sending OTP...");
                },
                success: function (response) {
                    console.log("OTP sent successfully:", response);

                    $('#otp-container').show();
                    $('input[name="phone"]').prop('readonly', true);
                    $('#otp-form input[name="phone"]').val(phone);
                },
                error: function (error) {
                    console.error("Error sending OTP:", error);
                    alert('Error: ' + error.responseJSON.message);
                }
            });
        });

        // OTP Verification
        $('#verify-otp-btn').on('click', function () {
            const phone = $('input[name="phone"]').val();
            const otp = $('input[name="otp"]').val();

            if (!otp) {
                alert('Please enter the OTP.');
                return;
            }

            console.log("Verifying OTP for phone: " + phone);

            $.ajax({
                url: '{{ route("password.verifyOtp") }}',
                method: 'POST',
                data: {
                    phone: phone,
                    otp: otp,
                    _token: $('meta[name="csrf-token"]').attr('content')
                },
                beforeSend: function () {
                    console.log("Verifying OTP...");
                },
                success: function (response) {
                    console.log("OTP verified successfully:", response);

                    $('#new-password-form').show();
                    $('#otp-container').hide();
                    $('input[name="otp"]').prop('readonly', true);

                    $('input[name="token"]').val(response.token); // Set token for the password reset form
                    $('input[name="phone"]').val(phone); // Ensure phone is also set
                },
                error: function (error) {
                    console.error("Error verifying OTP:", error);
                    alert('Error: ' + error.responseJSON.message);
                }
            });
        });

        $('#password-reset-form').on('submit', function (e) {
    e.preventDefault();

    const phone = $('input[name="phone"]').val();
    const token = $('input[name="token"]').val();
    const password = $('input[name="password"]').val();
    const passwordConfirmation = $('input[name="password_confirmation"]').val();

    console.log('Phone:', phone);
    console.log('Token:', token);

    $.ajax({
        url: '{{ route("password.update") }}',
        method: 'PUT',
        data: {
            phone: phone,
            token: token,
            password: password,
            password_confirmation: passwordConfirmation,
            _token: $('meta[name="csrf-token"]').attr('content')
        },
        success: function (response) {
            console.log('Password reset successful:', response);
            alert('Password reset successfully!');
            window.location.href = '/login';
        },
        error: function (error) {
            console.error('Error resetting password:', error);
            alert('Error: ' + (error.responseJSON?.message || 'Unknown error'));
        }
    });
});
    });
</script>
