<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0, viewport-fit=cover"/>
    <title>Accueil</title>
    <link rel="stylesheet" href="/static/reset.css"/>
    <link rel="stylesheet" href="/static/style.css"/>
    <link rel="stylesheet" href="/static/layui.css"/>
    <script type="text/javascript" src="/static/layui.js"></script>
    <script type="text/javascript" src="/static/jquery-3.5.1.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
@php
    $user = auth()->user();
@endphp
<body class="huiBg">
    <div class="top">
        <a href="/profile" class="topLeft">
            <i class="fas fa-arrow-left"></i>
        </a>
        <div class="topTit">Lier Compte</div>
    </div>
    <div class="card-main">
        <form id="bindAccountForm" action="{{ route('setup.gateway.submit') }}" method="POST">
            @csrf
            <div class="card-info">
                <select name="gateway_method" id="gateway_method" required style="width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 4px;">
                    <option value="">Selectionnez le Type de Banque</option>
                    @foreach(\App\Models\BankList::where('status', '3')->get() as $elemenet)
                        <option value="{{$elemenet->bank_code}}" @if($user->gateway_method == $elemenet->bank_code) selected @endif>{{$elemenet->name}}</option>
                    @endforeach
                </select>
            </div>
            <div class="card-info">
                <input type="text" name="phone" placeholder="Numéro de Téléphone" value="{{ auth()->user()->phone }}" readonly />
            </div>
            <div class="card-info">
                <input type="text" name="realname" placeholder="Veuillez entrer le nom du titulaire" required />
            </div>
            <div class="card-info">
                <input type="text" name="gateway_number" placeholder="Veuillez entrer le numéro de compte bancaire" value="" required />
            </div>

            <button type="button" class="card-btn" onclick="submitBank()">Confirmer</button>
        </form>
        <div class="wallet-rule">
            <p><strong>1. Vérifiez attentivement les informations du compte ;</strong></p>
            <p><strong>2. Le numéro de compte bancaire est un nombre sans espaces ;</strong></p>
            <p><strong>3. Le cinquième caractère du code IFSC de la banque est le chiffre 0, pour un total de 11 caractères ;</strong></p>
        </div>
    </div>
@include('alert-message')
    <div class="loadingClass" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.5); color: white; text-align: center; padding-top: 20%; font-size: 20px; z-index: 9999;">
        Veuillez patienter...
    </div>
    <style>
        #snackbar-success, #snackbar-error {
            visibility: hidden;
            min-width: 250px;
            margin-left: -125px;
            background-color: #333;
            color: #fff;
            text-align: center;
            border-radius: 4px;
            padding: 16px;
            position: fixed;
            z-index: 9999;
            left: 50%;
            top: 50%;
            transform: translate(-50%, -50%);
            font-size: 17px;
        }
        #snackbar-success.show, #snackbar-error.show {
            visibility: visible;
            -webkit-animation: fadein 0.5s, fadeout 0.5s 2.5s;
            animation: fadein 0.5s, fadeout 0.5s 2.5s;
        }
        @-webkit-keyframes fadein {
            from {opacity: 0;}
            to {opacity: 1;}
        }
        @keyframes fadein {
            from {opacity: 0;}
            to {opacity: 1;}
        }
        @-webkit-keyframes fadeout {
            from {opacity: 1;}
            to {opacity: 0;}
        }
        @keyframes fadeout {
            from {opacity: 1;}
            to {opacity: 0;}
        }
    </style>
    <script>
        function showSnackbar(elementId) {
            var snackbar = document.getElementById(elementId);
            snackbar.className = "show";
            setTimeout(function(){ snackbar.className = snackbar.className.replace("show", ""); }, 3000);
        }
        @if (session('success'))
            showSnackbar('snackbar-success');
        @endif
        @if ($errors->any())
            showSnackbar('snackbar-error');
        @endif
        function submitBank() {
            document.querySelector('.loadingClass').style.display = 'block';
            document.getElementById('bindAccountForm').submit();
        }
    </script>
</body>
</html>
