<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>WAF | Mon Compte</title>
    <link rel="stylesheet" href="/static/reset.css"/>
    <link rel="stylesheet" href="/static/style.css"/>
    <link rel="stylesheet" href="/static/layui.css"/>
    <script type="text/javascript" src="/static/layui.js"></script>
    <script type="text/javascript" src="/static/jquery-3.5.1.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body class="homeColor">
    <div class="top">
        <a href="/profile" class="topLeft">
            <i class="layui-icon layui-icon-left"></i>
        </a>
        <div class="topTit">Historique des Transactions</div>
    </div>
    <div class="history-main">
        <div class="record-tab">
            <a href="#" data-tab="cash" class="tab-link active">Argent</a>
            <a href="#" data-tab="recharge" class="tab-link">Recharge</a>
            <a href="#" data-tab="withdraw" class="tab-link">Retrait</a>
        </div>

        <div id="cash-records" class="history-list" style="display: block;">
            @foreach($cashRecords as $record)
                <div class="list-item">
                    <div class="list-left">
                        <h3>{{ $record->title }}</h3>
                        <p>{{ \Carbon\Carbon::parse($record->created_at)->format('M,d,Y,H:i:s') }}</p>
                    </div>
                    <div class="list-right">
                        {{ $record->credit > 0 ? '+' : '-' }}{{ price($record->amount) }}
                    </div>
                </div>
            @endforeach
        </div>
        <div id="recharge-records" class="history-list" style="display: none;">
            @foreach($rechargeRecords as $record)
                <div class="list-item">
                    <div class="list-left">
                        <h3>{{ $record->order_id }}</h3>
                        <p>{{ \Carbon\Carbon::parse($record->created_at)->format('M,d,Y,H:i:s') }}</p>
                    </div>
                    <div class="list-right">
                        {{ price($record->final_amount) }}
                        <span class="{{ $record->status === 'approved' ? '' : 'disabled' }}">
                            {{ $record->status === 'approved' ? 'Succes' : ($record->status === 'rejected' ? 'Echoue' : ucfirst($record->status)) }}
                        </span>
                    </div>
                </div>
            @endforeach
        </div>
        <div id="withdraw-records" class="history-list" style="display: none;">
            @foreach($withdrawRecords as $record)
                <div class="list-item">
                    <div class="list-left">
                        <h3>{{ $record->oid }}</h3>
                        <p>{{ \Carbon\Carbon::parse($record->created_at)->format('M d, Y H:i:s') }}</p>
                    </div>
                    <div class="list-right">
                        {{ price($record->final_amount) }}
                        <span class="{{ $record->status === 'approved' ? '' : 'disabled' }}">
                            @switch($record->status)
                                @case('approved')
                                    Reussi
                                    @break
                                @case('pending')
                                    En cours
                                    @break
                                @case('rejected')
                                    Echoue
                                    @break
                                @default
                                    {{ ucfirst($record->status) }}
                            @endswitch
                        </span>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const tabs = document.querySelectorAll('.tab-link');
            const recordSections = document.querySelectorAll('.history-list');

            tabs.forEach(tab => {
                tab.addEventListener('click', function (event) {
                    event.preventDefault();
                    tabs.forEach(t => t.classList.remove('active'));
                    recordSections.forEach(section => section.style.display = 'none');
                    this.classList.add('active');

                    const target = this.getAttribute('data-tab');
                    document.getElementById(target + '-records').style.display = 'block';
                });
            });
        });
    </script>
</body>
</html>
