<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0, viewport-fit=cover">
  <title>WAF | Mon Produit</title>
  <link rel="stylesheet" href="/static/reset.css">
  <link rel="stylesheet" href="/static/style.css">
  <link rel="stylesheet" href="/static/layui.css">
  <script src="/static/layui.js"></script>
  <script src="/static/jquery-3.5.1.min.js"></script>
</head>
<body class="homeColor">
  <div class="top">
    <a href="/profile" class="topLeft">
      <i class="layui-icon layui-icon-left"></i>
    </a>
    <div class="topTit">Mon Produit</div>
  </div>
  @php
    $totalAssets = \App\Models\Purchase::where('user_id', auth()->id())
        ->where('status', 'active')
        ->sum('amount');
  @endphp
  <div class="myorder">
    <div class="balance-list">
      <div class="balance-item">
        <h3>{{ $totalAssets }}</h3>
        <p>Total des Actifs</p>
      </div>
      <div class="balance-item">
        <h3>{{ price(auth()->user()->product_income) }}</h3>
        <p>Revenu Total</p>
      </div>
    </div>
    <div class="record-tab">
      <a href="javascript:void(0);" class="tab-link active" data-status="active">Valide</a>
      <a href="javascript:void(0);" class="tab-link" data-status="inactive">Expiré</a>
    </div>
    <div class="order-list" id="order-lis">
      @php
        $activePackages = \App\Models\Purchase::where('user_id', auth()->id())
          ->where('status', 'active')
          ->with('package')
          ->get();
        $inactivePackages = \App\Models\Purchase::where('user_id', auth()->id())
          ->where('status', 'inactive')
          ->with('package')
          ->get();
      @endphp
      @foreach($activePackages as $purchase)
        <div class="product-info active">
          <div class="product-img">
            <img src="{{ asset($purchase->package->photo) }}" alt="Image du Produit: {{ $purchase->package->name }}">
          </div>
          <div class="product-text">
            <h3>{{ $purchase->package->name }}</h3>
            <p>Prix: <span>{{ price($purchase->package->price) }}</span></p>
            <p>Cycle: <span>{{ $purchase->package->validity }} Jours</span></p>
            <p>Revenu Quotidien: <span>{{ price($purchase->package->daily_income) }}</span></p>
          </div>
          <div class="product-btm">
            <a href="javascript:void(0);" class="rental-link" data-package-id="{{ $purchase->id }}"
              @if(auth()->user()->receive_able_amount == 0)
                style="pointer-events: none; opacity: 0.5;"
              @endif>
              Obtenir un Revenu
            </a>
          </div>
        </div>
      @endforeach
      @foreach($inactivePackages as $purchase)
        <div class="product-info inactive" style="display: none;">
          <div class="product-img">
            <img src="{{ asset($purchase->package->photo) }}" alt="Image du Produit: {{ $purchase->package->name }}">
          </div>
          <div class="product-text">
            <h3>{{ $purchase->package->name }}</h3>
            <p>Prix: <span>{{ price($purchase->package->price) }}</span></p>
            <p>Cycle: <span>{{ $purchase->package->validity }} Jours</span></p>
            <p>Revenu Quotidien: <span>{{ price($purchase->package->daily_income) }}</span></p>
          </div>
          <div class="product-btm">
            <a href="javascript:void(0);" class="rental-link" data-package-id="{{ $purchase->id }}"
              @if(auth()->user()->receive_able_amount == 0)
                style="pointer-events: none; opacity: 0.5;"
              @endif>
              Obtenir un Revenu
            </a>
          </div>
        </div>
      @endforeach
      <p class="no-data" style="display: none;">Plus de Données.</p>
    </div>
  </div>
  <script>
    $(document).ready(function () {
      function toggleProducts(status) {
        if (status === 'active') {
          $('.product-info.active').show();
          $('.product-info.inactive').hide();
        } else {
          $('.product-info.active').hide();
          $('.product-info.inactive').show();
        }
        $('.no-data').toggle($('.product-info:visible').length === 0);
      }
      toggleProducts('active');
      $('.tab-link').on('click', function () {
        $('.tab-link').removeClass('active');
        $(this).addClass('active');
        toggleProducts($(this).data('status'));
      });
      $(document).on('click', '.rental-link', function () {
        const packageId = $(this).data('package-id');
        $.ajax({
          url: '{{ route("user.received.amount") }}',
          type: 'GET',
          data: { package_id: packageId, _token: '{{ csrf_token() }}' },
          success: function (response) {
            alert(response.message);
            if (response.status) location.reload();
          },
          error: function () {
            alert('Une erreur est survenue lors du traitement de votre demande.');
          }
        });
      });
    });
  </script>
</body>
</html>
