<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>LK6800 Chicken Rental</title>
  <style>
    body {
      margin: 0;
      padding: 0;
      font-family: 'Segoe UI', Tahoma, sans-serif;
      background-color: #f4f6f8;
      color: #333;
    }

    .header {
      background: linear-gradient(to right, #55b432, #4aa728);
      color: white;
      text-align: center;
      padding: 15px;
      font-size: 22px;
      font-weight: bold;
      box-shadow: 0 2px 6px rgba(0,0,0,0.1);
    }

    .product-image {
      width: 100%;
      height: 220px;
      object-fit: cover;
      border-bottom: 4px solid #55b432;
    }

    .product-box {
      background-color: white;
      padding: 20px;
      margin: 16px;
      border-radius: 12px;
      box-shadow: 0 4px 10px rgba(0,0,0,0.05);
      position: relative;
    }

    .badge {
      position: absolute;
      top: -12px;
      right: 20px;
      background: #55b432;
      color: white;
      font-size: 12px;
      padding: 5px 10px;
      border-radius: 8px;
      box-shadow: 0 2px 5px rgba(0,0,0,0.15);
    }

    .product-title {
      font-size: 24px;
      font-weight: bold;
      margin-bottom: 18px;
      color: #222;
    }

    .stats-grid {
      display: grid;
      grid-template-columns: repeat(2, 1fr);
      gap: 12px;
    }

    .stat-box {
      background: #f9fafb;
      padding: 12px;
      border-radius: 10px;
      text-align: center;
      border: 1px solid #eee;
    }

    .stat-label {
      font-size: 13px;
      color: #777;
    }

    .stat-value {
      font-size: 17px;
      font-weight: bold;
      color: #55b432;
      margin-top: 5px;
    }

    .desc {
      background-color: #fff;
      margin: 16px;
      padding: 16px;
      border-radius: 12px;
      font-size: 15px;
      line-height: 1.7;
      color: #444;
      box-shadow: 0 2px 8px rgba(0,0,0,0.04);
    }

    .rent-btn {
      background: linear-gradient(to right, #55b432, #4aa728);
      color: white;
      padding: 14px;
      width: 92%;
      margin: 20px auto 80px;
      display: block;
      text-align: center;
      font-size: 18px;
      font-weight: bold;
      border: none;
      border-radius: 30px;
      cursor: pointer;
      transition: background 0.3s ease, transform 0.2s ease;
    }

    .rent-btn:hover {
      background: linear-gradient(to right, #4aa728, #3e9223);
      transform: scale(1.02);
    }

    .balance-bar {
      position: fixed;
      bottom: 0;
      left: 0;
      width: 100%;
      background-color: #fff;
      border-top: 1px solid #ddd;
      padding: 12px 15px;
      font-size: 15px;
      color: #333;
      display: flex;
      justify-content: space-between;
      box-shadow: 0 -2px 6px rgba(0,0,0,0.03);
      z-index: 10000;
    }

    .balance-bar strong {
      color: #55b432;
    }

    /* Modal */
    .rental-modal {
      position: fixed;
      bottom: 0;
      left: 0;
      width: 100%;
      background: #fff;
      border-top-left-radius: 20px;
      border-top-right-radius: 20px;
      box-shadow: 0 -2px 10px rgba(0,0,0,0.2);
      z-index: 9999;
      display: none;
      padding: 20px;
      animation: slideUp 0.3s ease-out;
    }

    @keyframes slideUp {
      from { transform: translateY(100%); }
      to { transform: translateY(0); }
    }

    .modal-header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      border-bottom: 1px solid #eee;
      margin-bottom: 10px;
    }

    .modal-header h3 {
      margin: 0;
      font-size: 18px;
    }

    .close-btn {
      background: none;
      border: none;
      font-size: 20px;
      cursor: pointer;
    }

    .balance-section p,
    .rental-info p {
      margin: 8px 0;
      font-size: 14px;
    }

    .wallet-select label {
      display: block;
      margin: 10px 0;
      font-size: 15px;
    }

    .wallet-select input {
      margin-right: 8px;
    }

    .modal-actions {
      display: flex;
      justify-content: space-between;
      margin-top: 20px;
    }

    .modal-actions button {
      flex: 1;
      margin: 0 5px;
      padding: 12px;
      border: none;
      border-radius: 10px;
      font-weight: bold;
      cursor: pointer;
      font-size: 16px;
    }

    .modal-actions button:first-child {
      background: #28a745;
      color: white;
    }

    .modal-actions button:last-child {
      background: #dc3545;
      color: white;
    }
  </style>
</head>
<body>

  <div class="header">Product Detail</div>

  <img src="{{ $package->photo }}" alt="LK6800 Chicken" class="product-image">

  <div class="product-box">
    <div class="badge">Rental Limit: {{ $package->buy_limit }}</div>
    <div class="product-title">{{ $package->name }}</div>

    <div class="stats-grid">
      <div class="stat-box">
        <div class="stat-label">Rental Amount</div>
        <div class="stat-value">{{price( $package->price )}}</div>
      </div>
      <div class="stat-box">
        <div class="stat-label">Cycle</div>
        <div class="stat-value">{{ $package->validity }} Days</div>
      </div>
      <div class="stat-box">
        <div class="stat-label">Daily Income</div>
        <div class="stat-value">{{price( $package->daily_amount )}}</div>
      </div>
      <div class="stat-box">
        <div class="stat-label">Estimated Total</div>
        <div class="stat-value">{{price( $package->daily_amount * $package->validity )}}</div>
      </div>
    </div>
  </div>

  <div class="desc">
    You earn <strong>{{price ($package->daily_amount )}}  per day</strong> by renting high-grade chickens of the {{ $package->name }} package.<br><br>
    ✅ Rental period is <strong>{{ $package->validity }}days</strong>, giving you a total income of <strong>{{price( $package->daily_amount * $package->validity )}}</strong>.<br><br>
    <!--⚠️ Each user can rent this product <strong>{{ $package->buy_limit }} only</strong>.<br><br>
    💰 Invite bonus: <strong>₦550</strong> for referring new members.<br>
    🎉 Join bonus: <strong>₦500</strong> for every new member who registers.
  --></div>
  <form id="rental-form" action="{{ route('buy.package', ['id' => $package->id]) }}" method="POST">
        @csrf
  <button class="rent-btn" onclick="buyProduct('{{$package->id}}')">Rent Now</button>

  <div class="balance-bar">
    <div>Your Balance:<strong>           {{ price(auth()->user()->balance) }}</strong></div>
  </div>

  <!-- Rental Modal --
  <div id="rentalModal" class="rental-modal">
    <div class="modal-header">
      <h3>Confirm Rental</h3>
      <button class="close-btn" onclick="closeRentalModal()">✖</button>
    </div>

    <div class="balance-section">
      <p><strong>🔐 Main Wallet:</strong> {{ price(auth()->user()->balance) }}</p>
      <p><strong>🎁 Bonus Wallet:</strong> {{ price(auth()->user()->bonus_balance) }}</p>
    </div>

    <div class="rental-info">
      <p><strong>🐔 Product:</strong> LK6800 Chicken</p>
      <p><strong>💰 Price:</strong> {{ price(6800) }}</p>
      <p><strong>⏱ Duration:</strong> 42 days</p>
      <p><strong>📈 Profit:</strong> {{ price(356) }} / day</p>
    </div>

    <form id="rentalForm" method="POST" action="{{ url('user.rent.confirm') }}">
      @csrf
      <input type="hidden" name="product_id" value="6800">
      <input type="hidden" name="wallet_type" id="walletType">

      <div class="wallet-select">
        <label><input type="radio" name="wallet" value="main"> Use Main Wallet</label>
        <label><input type="radio" name="wallet" value="bonus"> Use Bonus Wallet</label>
      </div>

      <div class="modal-actions">
        <button type="button" onclick="submitRental()">✅ Confirm</button>
        <button type="button" onclick="closeRentalModal()">❌ Cancel</button>
      </div>-->
    </form>
  </div>
  @include('alert-message')
<script>
    function buyProduct(id){
  document.querySelector('.loading').style.display = 'block';
  window.location.href = '{{url('purchase/confirmation')}}' + '/' + id;
}
</script>

<script>
    function menuActive(_this, menuName){
        var elements = document.querySelectorAll('.typeitem');
        for (let i=0;i<elements.length;i++){
            if (elements[i].classList.contains('typeover')){
                elements[i].classList.remove('typeover')
            }
        }
        _this.classList.add('typeover')

        if (menuName == 'product'){
            document.getElementById('list').style.display='block';
            document.getElementById('mylist').style.display='none';
        }
        if (menuName == 'myproduct'){
            document.getElementById('list').style.display='none';
            document.getElementById('mylist').style.display='block';
        }
    }
</script>
</body>
</html>

  <!--<script>
    /*function openRentalModal() {
      document.getElementById('rentalModal').style.display = 'block';
    }

    function closeRentalModal() {
      document.getElementById('rentalModal').style.display = 'none';
    }*

    function submitRental() {
      //const selected = document.querySelector('input[name="wallet"]:checked');
      //if (!selected) {
        alert('Please select a wallet!');
        return;
      }
      document.getElementById('walletType').value = selected.value;
      document.getElementById('rentalForm').submit();
    }
  </script>
</body>
</html>-->
