<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <title>Page de Salaire</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    * {
      box-sizing: border-box;
    }

    body {
      font-family: 'Segoe UI', sans-serif;
      background-color: #f5f5f5;
      margin: 0;
      padding: 0;
    }
    .top-bar {
      display: flex;
      align-items: center;
      background-color: #55b432;
      color: white;
      padding: 14px 16px;
      position: sticky;
      top: 0;
      z-index: 999;
    }
    .back-btn {
      text-decoration: none;
      color: white;
      font-size: 20px;
      margin-right: 16px;
    }
    .title {
      flex-grow: 1;
      text-align: center;
      font-size: 16px;
      margin-right: 32px;
      font-weight: bold;
    }
    .tabs {
      display: flex;
      justify-content: center;
      margin: 20px 0;
    }
    .tabs button {
      background-color: #e0e0e0;
      border: none;
      padding: 10px 20px;
      margin: 0 5px;
      border-radius: 20px;
      font-weight: bold;
      cursor: pointer;
      color: #333;
      transition: background-color 0.3s;
    }
    .tabs button.active {
      background-color: #55b432;
      color: white;
    }
    .tab-content {
      display: none;
      padding: 0 20px 20px;
    }
    .tab-content.active {
      display: block;
    }
    .card {
      background: white;
      border-radius: 12px;
      box-shadow: 0 4px 8px rgba(0,0,0,0.1);
      padding: 16px;
      margin-bottom: 16px;
      border-top: 6px solid #55b432;
    }
    .card h3 {
      margin: 0 0 10px;
      font-size: 16px;
      color: #fff;
      background: #55b432;
      border-radius: 6px 6px 0 0;
      padding: 8px 12px;
    }
    .info-row {
      display: flex;
      justify-content: space-between;
      margin: 12px 0;
      text-align: center;
    }
    .info-box {
      flex: 1;
    }
    .info-box p {
      margin: 4px 0;
      color: #777;
      font-size: 13px;
    }
    .info-box .value {
      font-weight: bold;
      font-size: 18px;
      color: #333;
    }
    .progress-container {
      background: #d8dee3;
      border-radius: 12px;
      height: 12px;
      overflow: hidden;
      margin: 12px 0;
    }
    .progress-fill {
      height: 100%;
      background-color: #55b432;
      width: 0;
      transition: width 0.4s ease;
    }
    .progress-text {
      text-align: center;
      font-size: 13px;
      color: #333;
      margin-top: 4px;
    }
    .footer {
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-top: 8px;
    }
    .footer .amount {
      font-weight: bold;
      font-size: 16px;
    }
    .footer button {
      padding: 8px 16px;
      border: none;
      border-radius: 20px;
      font-weight: bold;
      cursor: pointer;
      transition: 0.3s;
    }
    .footer .claim-btn {
      background-color: #55b432;
      color: white;
    }
    .footer .disabled {
      background-color: #ccc;
      color: white;
      cursor: not-allowed;
    }
    .card:hover {
      transform: scale(1.01);
      transition: 0.2s ease-in-out;
    }
  </style>
</head>
<body>
<div class="top-bar">
  <a href="javascript:history.back()" class="back-btn">&larr;</a>
  <div class="title">Salaire</div>
</div>
<!-- Onglets -->
<div class="tabs">
  <button class="tab-button active" onclick="showTab(event, 'weekly')">Salaire Hebdomadaire</button>
  <button class="tab-button" onclick="showTab(event, 'monthly')">Salaire Mensuel</button>
</div>
<!-- Onglet Salaire Hebdomadaire -->
<div id="weekly" class="tab-content active">
  @foreach ($weekly_salaries as $salary)
    @php
      $isClaimed = in_array($salary['bonus'], $claimed_weekly_bonuses);
      $metCondition = $current_invite_count >= $salary['required'];
      $progress = min(100, intval(($current_invite_count / $salary['required']) * 100));
    @endphp
    <div class="card">
      <h3>Salaire Hebdomadaire</h3>
      <div class="info-row">
        <div class="info-box"><p>Invitations Valides</p><p class="value">{{ $current_invite_count }}</p></div>
        <div class="info-box"><p>Termine</p><p class="value">{{ min($salary['required'], $current_invite_count) }}</p></div>
        <div class="info-box"><p>Bonus de Salaire</p><p class="value">{{ $salary['bonus'] }} R</p></div>
      </div>
      <div class="progress-container">
        <div class="progress-fill" style="width: {{ $progress }}%;"></div>
      </div>
      <div class="progress-text">{{ min($salary['required'], $current_invite_count) }} / {{ $salary['required'] }}</div>
      <div class="footer">
        <span class="amount">{{ $salary['bonus'] }} R</span>
        @if ($isClaimed)
          <button class="disabled">Deja Recu</button>
        @elseif ($metCondition)
          <form method="POST" action="{{ route('reward.claim.weekly') }}">
            @csrf
            <input type="hidden" name="bonus" value="{{ $salary['bonus'] }}">
            <button class="claim-btn">Obtenir le Bonus</button>
          </form>
        @else
          <button class="disabled">Pas Encore</button>
        @endif
      </div>
    </div>
  @endforeach
</div>
<!-- Onglet Salaire Mensuel -->
<div id="monthly" class="tab-content">
  <div class="card">
    <h3>Salaire Mensuel</h3>
    <div class="info-row">
      <div class="info-box"><p>Invitations Valides</p><p class="value">{{ $monthly_invite_count }}</p></div>
      <div class="info-box"><p>Termine</p><p class="value">{{ $monthly_invite_count }}</p></div>
      <div class="info-box"><p>Bonus de Salaire</p><p class="value">{{ $monthly_salary }} R</p></div>
    </div>
    <div class="progress-container">
      @php
        $target = $monthly_salary == 10000 ? 20 : ($monthly_salary == 5000 ? 10 : 0);
        $progress = $target > 0 ? min(100, intval(($monthly_invite_count / $target) * 100)) : 0;
      @endphp
      <div class="progress-fill" style="width: {{ $progress }}%;"></div>
    </div>
    <div class="progress-text">{{ min($monthly_invite_count, $target) }} / {{ $target }}</div>
    <div class="footer">
      <span class="amount">{{ $monthly_salary }} R</span>
      @if ($monthly_salary_claimed)
        <button class="disabled">Deja Recu</button>
      @elseif ($monthly_salary > 0)
        <form method="POST" action="{{ route('reward.claim.monthly') }}">
          @csrf
          <button class="claim-btn">Obtenir le Bonus</button>
        </form>
      @else
        <button class="disabled">Pas Encore</button>
      @endif
    </div>
  </div>
</div>
@include('alert-message')
<!-- JS -->
<script>
  function showTab(event, tabId) {
    document.querySelectorAll('.tab-button').forEach(btn => btn.classList.remove('active'));
    document.querySelectorAll('.tab-content').forEach(tab => tab.classList.remove('active'));
    event.target.classList.add('active');
    document.getElementById(tabId).classList.add('active');
  }
</script>
</body>
</html>
