<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0, viewport-fit=cover"/>
    <title>WAF | Bonus</title>
    <link rel="stylesheet" href="/static/reset.css"/>
    <link rel="stylesheet" href="/static/style.css"/>
    <link rel="stylesheet" href="/static/layui.css"/>
    <script type="text/javascript" src="/static/layui.js"></script>
    <script type="text/javascript" src="/static/jquery-3.5.1.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body class="huiBg">
    <div class="top">
        <a href="/profile" class="topLeft">
            <i class="fas fa-arrow-left"></i>
        </a>
        <div class="topTit">Bonus</div>
    </div>
    <div class="bonus-main">
        <div class="balance-list">
            <div class="balance-item">
                <h3><span>{{price(auth()->user()->balance) }}</span></h3>
                <p>Portefeuille de Solde</p>
            </div>
        </div>

        <div class="bonus-bg">
            <div class="bouns-input">
                <input type="text" id="code" name="code" placeholder="Veuillez entrer le code bonus" />
            </div>
            <div class="bouns-input">
                <button type="button" id="claim-bonus" class="btn">Obtenir</button>
            </div>
        </div>

        <!-- HTML Snackbar -->
        <div id="snackbar"></div>
        <div id="loading" class="loading-spinner" style="display: none;">
            <div class="spinner"></div>
        </div>
    </div>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const claimBonusButton = document.getElementById('claim-bonus');
            const snackbar = document.getElementById('snackbar');
            const loadingSpinner = document.getElementById('loading');

            claimBonusButton.addEventListener('click', function () {
                const code = document.getElementById('code').value;
                loadingSpinner.style.display = 'flex';

                fetch(`/submit-bonus-amount/${code}`)
                    .then(response => response.json())
                    .then(data => {
                        loadingSpinner.style.display = 'none';

                        if (data.status) {
                            showSnackbar(`Bonus obtenu avec succes! ${data.message}`, 'success');
                        } else {
                            showSnackbar(data.message || 'Impossible de reclamer le bonus.', 'error');
                        }
                    })
                    .catch(error => {
                        console.error("Erreur lors de la reclamation du bonus:", error);
                        loadingSpinner.style.display = 'none';
                        showSnackbar('Erreur lors de la reclamation du bonus.', 'error');
                    });
            });

            function showSnackbar(message, type) {
                snackbar.textContent = message;
                snackbar.className = 'show ' + (type === 'success' ? 'success' : 'error');
                snackbar.style.display = 'block';
                setTimeout(() => {
                    snackbar.style.display = 'none';
                }, 3000);
            }
        });
    </script>
    <style>
        #snackbar {
            display: none;
            position: fixed;
            left: 50%;
            top: 50%;
            transform: translate(-50%, -50%);
            background-color: #fff;
            color: #000000;
            padding: 16px;
            border-radius: 5px;
            z-index: 1000;
            transition: visibility 0s, opacity 0.5s linear;
            opacity: 0;
        }
        #snackbar.show {
            visibility: visible;
            opacity: 1;
        }
        #snackbar.success {
            background-color: white;
        }
        #snackbar.error {
            background-color: white;
        }
    </style>
</body>
</html>
