<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0, viewport-fit=cover"/>
    <title>WAF FARMS | Mon Compte</title>
    <link rel="stylesheet" href="/static/reset.css"/>
    <link rel="stylesheet" href="/static/style.css"/>
    <link rel="stylesheet" href="/static/layui.css"/>
    <script type="text/javascript" src="/static/layui.js"></script>
    <script type="text/javascript" src="/static/jquery-3.5.1.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
    </style>
</head>
<body class="huiBg">
    <div class="top">
        <a href="/home" class="topLeft">
            <i class="fas fa-arrow-left"></i>
        </a>
        <div class="topTit">Retrait</div>
    </div>

    <div class="wallet-box">
        <form action="{{ route('user.withdraw.request') }}" method="POST">
            @csrf
            <div class="balance-list">
                <div class="balance-item">
                    <h3>{{ price(auth()->user()->balance) }}</h3>
                    <p>Portefeuille de Retrait</p>
                </div>
            </div>
            <div class="wallet-card">
                <h3>Nom du Titulaire</h3>
                <p>{{ auth()->user()->name }}</p>
            </div>
            <div class="wallet-card">
                <h3>Numéro de Compte</h3>
                <p>{{ auth()->user()->gateway_number }}</p>
            </div>
            <div class="wallet-card">
                <h3>Type de Banque</h3>
                <p>{{ auth()->user()->gateway_method }}</p>
            </div>
            <div class="wallet-item">
                <h3>Montant du Retrait</h3>
                <div class="wallet-input">
                    <input type="number" name="amount" placeholder="Veuillez entrer le montant du retrait" required min="100">
                    <i>R</i>
                </div>
            </div>
            <button type="submit" class="wallet-btn">Retrait</button>
        </form>
        <div class="wallet-rule">
            <p><strong>1. Montant minimum de retrait : 100 R</strong></p>
            <p><strong>2. Frais de retrait : 18%</strong></p>
            <p><strong>3. Vous pouvez retirer tous les jours</strong></p>
            <p><strong>4. Retrait 24/7</strong></p>
        </div>
    </div>
    @include('alert-message')
</body>
</html>
