<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>Forgot Password</title>
    <link rel="stylesheet" href="/static/reset.css"/>
    <link rel="stylesheet" href="/static/style.css"/>
    <script type="text/javascript" src="/static/jquery-3.5.1.min.js"></script>
    <script type="text/javascript" src="/static/layui.js"></script>
</head>
<body>
    <div class="top">
        <a href="#" class="topLeft"><i class="layui-icon layui-icon-left"></i></a>
        <div class="topTit">Forgot Password</div>
    </div>

    <div class="warp">
        <div class="login-head">
            <img src="{{ asset('public/static/img/logo.b086b4ea.png') }}" alt="Logo">
        </div>

        <div class="login">
            <!-- OTP Request Form -->
            <form id="otp-form" action="{{ route('password.requestOtp') }}" method="POST">
                @csrf
                <div class="circlebg">
                    <input type="text" name="phone" placeholder="Enter Phone Number" required>
                    <button type="submit" class="otpBtn login-main-otp-btn">Send OTP</button>
                </div>
            </form>

            <!-- OTP Verification Form (Hidden initially) -->
            <div class="circlebg otp-container" id="otp-container" style="display: none;">
                <input type="text" name="otp" placeholder="Enter OTP" required>
                <button type="button" class="otpBtn login-main-otp-btn" id="verify-otp-btn">Verify OTP</button>
            </div>

            <!-- Password Reset Form (Hidden initially) -->
            <div id="new-password-form" style="display: none;">
                <form id="password-reset-form" action="{{ route('password.update') }}" method="POST">
                    @csrf
                    @method('PUT')
                    <input type="hidden" name="phone">
                    <input type="hidden" name="token"> <!-- Token field -->

                    <div class="circlebg">
                        <input type="password" name="password" placeholder="New Password" required>
                    </div>
                    <div class="circlebg">
                        <input type="password" name="password_confirmation" placeholder="Confirm Password" required>
                    </div>
                    <div class="continue">
                        <button type="submit" class="add-btn login-btn">Reset Password</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function () {
            // OTP form submission
            $('#otp-form').on('submit', function (e) {
                e.preventDefault();

                $.ajax({
                    url: $(this).attr('action'),
                    method: 'POST',
                    data: $(this).serialize(),
                    success: function (response) {
                        $('#otp-container').show();
                        $('input[name="phone"]').prop('readonly', true);
                        $('#otp-form input[name="phone"]').val($('input[name="phone"]').val());
                    },
                    error: function (error) {
                        alert('Error: ' + error.responseJSON.message);
                    }
                });
            });

            // OTP verification
            $('#verify-otp-btn').on('click', function () {
                $.ajax({
                    url: '{{ route("password.verifyOtp") }}',
                    method: 'POST',
                    data: {
                        phone: $('input[name="phone"]').val(),
                        otp: $('input[name="otp"]').val(),
                        _token: '{{ csrf_token() }}'
                    },
                    success: function (response) {
                        $('#new-password-form').show();
                        $('#otp-container').hide();
                        $('input[name="otp"]').prop('readonly', true);

                        // Store the token in the password reset form
                        $('<input>').attr({
                            type: 'hidden',
                            name: 'token',
                            value: response.token
                        }).appendTo('#password-reset-form');
                    },
                    error: function (error) {
                        alert('Error: ' + error.responseJSON.message);
                    }
                });
            });

            // Password reset submission
            $('#password-reset-form').on('submit', function (e) {
                e.preventDefault();

                $.ajax({
                    url: $(this).attr('action'),
                    method: 'PUT',
                    data: $(this).serialize(),
                    success: function (response) {
                        alert(response.message);
                        window.location.href = '/login'; // Redirect to login page after successful password reset
                    },
                    error: function (error) {
                        alert('Error: ' + error.responseJSON.message);
                    }
                });
            });
        });
    </script>
</body>
</html>