<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Dashboard</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/layui@2.8.17/dist/css/layui.css"/>
  <style>
    body {
      background: #f7f7f7;
      font-family: 'Segoe UI', sans-serif;
      margin: 0;
    }

    /* Gradient Top Bar */
    .top-header {
      background: linear-gradient(135deg, #55b432, #3e8f2f);
      padding: 14px 16px;
      color: #fff;
      position: sticky;
      top: 0;
      z-index: 100;
      display: flex;
      align-items: center;
      justify-content: space-between;
    }

    .top-header .title {
      font-size: 18px;
      font-weight: bold;
    }

    .top-header img.avatar {
      width: 32px;
      height: 32px;
      border-radius: 50%;
      object-fit: cover;
    }

    .top-header .icons i {
      font-size: 20px;
      margin-left: 14px;
      cursor: pointer;
    }

    /* Banner */
    .carousel-container {
      margin: 12px 10px;
      border-radius: 14px;
      overflow: hidden;
    }

    .layui-carousel img {
      width: 100%;
      height: 180px;
      object-fit: cover;
      border-radius: 12px;
    }

    /* ROI Cards */
    .roi-stats {
      display: flex;
      justify-content: space-between;
      margin: 10px;
      gap: 10px;
    }

    .roi-card {
      flex: 1;
      background: #fff;
      border-radius: 10px;
      padding: 12px;
      text-align: center;
      box-shadow: 0 2px 5px rgba(0,0,0,0.05);
    }

    .roi-card h3 {
      font-size: 13px;
      color: #666;
    }

    .roi-card p {
      margin-top: 4px;
      font-size: 16px;
      font-weight: bold;
      color: #55b432;
    }

    /* Balance Card */
    .balance-card {
      background: linear-gradient(to right, #defada, #ffffff);
      margin: 15px 10px;
      border-radius: 14px;
      padding: 16px;
      box-shadow: 0 4px 8px rgba(0,0,0,0.04);
      display: flex;
      justify-content: space-around;
    }

    .balance-card .item {
      text-align: center;
    }

    .balance-card .item img {
      width: 24px;
      height: 24px;
      margin-bottom: 4px;
    }

    .balance-card .item .label {
      font-size: 13px;
      color: #444;
    }

    .balance-card .item .value {
      font-size: 15px;
      font-weight: bold;
      color: #3ca524;
    }

    /* Quick Actions */
    .quick-actions {
      display: grid;
      grid-template-columns: repeat(4, 1fr);
      gap: 10px;
      margin: 10px;
    }

    .action-btn {
      background: #fff;
      padding: 10px 6px;
      border-radius: 12px;
      box-shadow: 0 2px 6px rgba(0,0,0,0.06);
      text-align: center;
      transition: all 0.3s;
    }

    .action-btn:hover {
      transform: translateY(-3px);
      box-shadow: 0 4px 10px rgba(0,0,0,0.1);
    }

    .action-btn img {
      width: 30px;
      height: 30px;
      margin-bottom: 4px;
    }

    .action-btn div {
      font-size: 13px;
      color: #222;
    }
    /* Event Section */
    .section-title {
      margin: 15px 10px 8px;
      font-weight: bold;
      color: #55b432;
      border-left: 4px solid #55b432;
      padding-left: 8px;
    }


    /* Support Badge */
    .support-badge {
      position: fixed;
      bottom: 20px;
      right: 20px;
      background: #55b432;
      color: white;
      font-weight: bold;
      padding: 8px 12px;
      border-radius: 20px;
      box-shadow: 0 3px 10px rgba(0,0,0,0.1);
      font-size: 14px;
    }

    /* Scroll Notice */
    .scroll-notice {
      background: #e9ffe9;
      margin: 10px;
      padding: 6px 12px;
      font-size: 14px;
      color: #228822;
      white-space: nowrap;
      overflow: hidden;
      border-radius: 6px;
    }

    .scroll-notice span {
      display: inline-block;
      animation: scroll-left 12s linear infinite;
    }

    @keyframes scroll-left {
      from { transform: translateX(100%); }
      to { transform: translateX(-100%); }
    }
    .tab-buttons {
      display: flex;
      gap: 10px;
      padding: 15px;
      background: #fff;
      position: sticky;
      top: 58px;
      z-index: 90;
      box-shadow: 0 2px 5px rgba(0,0,0,0.04);
    }

    .tab-buttons button {
      flex: 1;
      padding: 10px;
      font-size: 15px;
      border: none;
      border-radius: 8px;
      cursor: pointer;
      background: #ccc;
      color: #fff;
      transition: 0.3s;
    }

    .tab-buttons button.active {
      background: #55b432;
      box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    }

    .product-tab {
      display: none;
      animation: fadeIn 0.3s ease;
    }

    .product-tab.active {
      display: block;
    }

    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(5px); }
      to { opacity: 1; transform: translateY(0); }
    }

    .product-box {
      background: #fff;
      border-radius: 12px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.06);
      margin: 15px;
      overflow: hidden;
      transition: transform 0.2s;
    }

    .product-box:hover {
      transform: scale(1.01);
    }

    .product-box.discount {
      background: #fffce6;
      border: 1px solid #f4c430;
    }

    .product-box.soldout {
      opacity: 0.6;
      pointer-events: none;
    }

    .product-header {
      background: #55b432;
      color: #fff;
      padding: 12px 16px;
      font-weight: bold;
      position: relative;
    }

    .badge {
      background: #ffc107;
      color: #000;
      padding: 3px 7px;
      font-size: 12px;
      border-radius: 4px;
      position: absolute;
      top: 12px;
      right: 16px;
    }

    .product-body {
      padding: 15px;
    }

    .product-content {
      display: flex;
      gap: 12px;
    }

    .product-left img {
      width: 85px;
      height: 85px;
      object-fit: cover;
      border-radius: 8px;
    }

    .product-info {
      flex: 1;
      font-size: 14px;
      color: #333;
    }

    .product-info p {
      margin: 6px 0;
      display: flex;
      justify-content: space-between;
    }

    .product-info span {
      color: #55b432;
      font-weight: 600;
    }

    .product-footer {
      margin-top: 10px;
      display: flex;
      justify-content: space-between;
      flex-wrap: wrap;
      align-items: center;
    }

    .price-discount {
      font-size: 14px;
    }

    .original-price {
      text-decoration: line-through;
      color: #888;
    }

    .discounted-price {
      color: red;
      font-weight: bold;
    }

    .countdown {
      font-size: 12px;
      color: #666;
      margin-top: 5px;
    }

    .rent-btn {
      background: #55b432;
      color: #fff;
      padding: 6px 15px;
      border-radius: 20px;
      text-decoration: none;
      transition: 0.3s;
    }

    .rent-btn:hover {
      background: #55b432;
    }

    .rent-btn.disabled {
      background: #222;
      pointer-events: none;
    }

    .no-more {
      text-align: center;
      color: #888;
      margin: 25px 0 5px;
      font-size: 14px;
    }
    .turntable {
    width: 56px;
    height: 56px;
    position: fixed;
    bottom: 120px;
    right: 3px;
    z-index: 5000;
}

.turntable a {
    width: 56px;
    height: 56px;
    display: inline-block;
    background: #ffffff;
    border-radius: 50%;
    margin: 5px 0;
    overflow: hidden;
}

.turntable img {
    width: 100%;
    animation: rotate 2s linear infinite;
    -webkit-animation: rotate 2s linear infinite;
    -moz-animation: rotate 2s linear infinite;
} 
/*home-notice*
body {
      margin: 0;
      padding: 0;
      font-family: "Segoe UI", sans-serif;
      background: #f2f2f2;
    }*/

    .overlay {
      position: fixed;
      inset: 0;
      background: rgba(0, 0, 0, 0.6);
      display: flex;
      align-items: center;
      justify-content: center;
      z-index: 999;
    }

    .popup {
      background: white;
      width: 90%;
      max-width: 400px;
      border-radius: 16px;
      padding: 20px;
      position: relative;
      box-shadow: 0 8px 16px rgba(0, 0, 0, 0.25);
      color: #0d1b3d;
      font-size: 14px;
      animation: fadeIn 0.4s ease-in-out;
    }

    @keyframes fadeIn {
      from { transform: scale(0.9); opacity: 0; }
      to { transform: scale(1); opacity: 1; }
    }

    .popup .close-btn {
      position: absolute;
      top: 10px;
      right: 14px;
      font-size: 18px;
      color: #4f46e5;
      cursor: pointer;
    }

    .popup p {
      margin: 10px 0;
      line-height: 1.6;
    }

    .popup p span {
      font-weight: bold;
    }

    .popup p:first-child span {
      color: red;
    }

    .popup button,
    .popup a.join-btn {
      display: block;
      width: 100%;
      margin-top: 12px;
      background-color: #55b432;
      color: white;
      border: none;
      border-radius: 25px;
      padding: 12px 0;
      font-size: 16px;
      text-align: center;
      text-decoration: none;
      cursor: pointer;
    }

    .popup a.join-btn {
      background-color: #25D366; /* WhatsApp green */
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 10px;
      font-weight: bold;
      box-shadow: 0 0 12px #25D36688;
      margin-top: 16px;
      transition: transform 0.2s;
    }

    .popup a.join-btn:hover {
      transform: scale(1.03);
    }

    .popup a.join-btn img {
      width: 20px;
      height: 20px;
    }

    .emoji {
      margin-right: 6px;
    }

    .emoji {
      margin-right: 6px;
    }
    @media (max-width: 600px) {
            .header-container {
                height: 30vh; 
            }
            .button-bar .button {
                flex: 1; 
                min-width: 60px; 
            }
        }

        @media (max-width: 400px) {
            .button-bar .button {
                flex: 1 1 100%; 
                max-width: none; 
            }
            
        }

  </style>
</head>
<body>

<!-- En-tête supérieur -->
<div class="top-header">
  <img src="<?php echo e(asset('public')); ?>/static/img/logo1.png" class="avatar" alt="Avatar">
  <div class="title">Accueil</div>
  <div class="icons">
    <i class="layui-icon layui-icon-notice"></i>
  </div>
</div>
<!-- Bannière -->
<div class="carousel-container">
  <div class="layui-carousel" id="banner-carousel">
    <div carousel-item>
      <img src="<?php echo e(asset('public/banner/image111.jpg')); ?>" alt="Bannière 1">
      <img src="<?php echo e(asset('public/banner/image222.jpg')); ?>" alt="Bannière 2">
    </div>
  </div>
</div>
<!-- Notice -->
<div class="scroll-notice">
  <span>🚀 Utilisateur 91***823 vient de gagner ₦4,800 | 💼 Nouveau plan ROI maintenant actif | 🏆 Invitez 5 amis et obtenez un bonus VIP</span>
</div>
<div class="quick-actions">
  <div class="action-btn" onclick="window.location.href='<?php echo e(url('deposit')); ?>'">
    <img src="<?php echo e(asset('static/img/Account (1).png')); ?>" alt="Recharge">
    <div>Recharge</div>
  </div>
  <div class="action-btn" onclick="window.location.href='<?php echo e(url('/about')); ?>'">
    <img src="<?php echo e(asset('static/img/about.png')); ?>" alt="À propos">
    <div>A propos</div>
  </div>
  <div class="action-btn" onclick="window.location.href='<?php echo e(url('my-team')); ?>'">
    <img src="<?php echo e(asset('static/img/Team_2.png')); ?>" alt="Equipe">
    <div>Equipe</div>
  </div>
  <div class="action-btn" onclick="window.location.href='<?php echo e(url('withdraw')); ?>'">
    <img src="<?php echo e(asset('static/img/msg.png')); ?>" alt="Retrait">
    <div>Retrait</div>
  </div>
  <div class="action-btn" onclick="window.location.href='<?php echo e(url('/spin')); ?>'">
    <img src="<?php echo e(asset('static/img/bonus.png')); ?>" alt="Echanger">
    <div>Echanger</div>
  </div>
  <div class="action-btn" onclick="window.location.href='<?php echo e(url('ordered')); ?>'">
    <img src="<?php echo e(asset('static/img/Order_2 (1).png')); ?>" alt="Mon Adoption">
    <div>Mon Adoption</div>
  </div>
  <div class="action-btn" onclick="window.location.href='<?php echo e(url('/check-in-page')); ?>'">
    <img src="<?php echo e(asset('static/img/m_11.png')); ?>" alt="Check-in Quotidien">
    <div>Check-in Quotidien</div>
  </div>
  <div class="action-btn" onclick="window.location.href='<?php echo e(url('/services')); ?>'">
    <img src="<?php echo e(asset('static/img/service (1).png')); ?>" alt="Support">
    <div>Support</div>
  </div>
</div>

</div>
<!-- Événements -->
<div class="section-title">Produits</div>
<div class="event-cards">
  <main>
    <?php
      use App\Models\Package;
      $packages = Package::where('status', 'active')->get()->groupBy('type');
    ?>

    <?php $__currentLoopData = ['fixed', 'welfare', 'activity']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <div class="product-tab <?php echo e($loop->first ? 'active' : ''); ?>" id="<?php echo e($cat); ?>">
        <?php $__currentLoopData = $packages[$cat] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <?php
            $isDiscounted = $package->discount_percentage > 0;
            $dailyIncome = round($package->commission_with_avg_amount / $package->validity, 2);
          ?>
          <div class="product-box <?php echo e($isDiscounted ? 'discount' : ''); ?> <?php echo e($package->is_sold_out ? 'soldout' : ''); ?>">
            <div class="product-header">
              <?php echo e($package->name); ?>

              <span class="badge"><?php echo e($isDiscounted ? 'Promo' : 'Standard'); ?></span>
            </div>
            <div class="product-body">
              <div class="product-content">
                <div class="product-left">
                  <img src="<?php echo e($package->photo); ?>" alt="<?php echo e($package->name); ?>">
                </div>
                <div class="product-info">
                  <p>Montant de location: <span><?php echo e(price($package->price)); ?></span></p>
                  <p>Cycle de revenu: <span><?php echo e($package->validity); ?> Jours</span></p>
                  <p>Revenu quotidien: <span><?php echo e(price($dailyIncome)); ?></span></p>
                  <p>Revenu estime: <span><?php echo e(price($package->commission_with_avg_amount)); ?></span></p>
                </div>
              </div>
              <div class="product-footer">
                <div class="price-discount">
                  <?php if($isDiscounted): ?>
                    <span class="original-price"><?php echo e(price($package->price)); ?></span>
                    <span class="discounted-price"><?php echo e(price($package->discounted_price)); ?></span>
                  <?php else: ?>
                    <span class="discounted-price"><?php echo e(price($package->price)); ?></span>
                  <?php endif; ?>
                  <?php if($package->show_timer): ?>
                    <div class="countdown" data-end="<?php echo e(now()->addDays(2)->toIso8601String()); ?>"></div>
                  <?php endif; ?>
                </div>
                <a href="<?php echo e(route('product.detail', ['id' => $package->id])); ?>"
                   class="rent-btn <?php echo e($package->is_sold_out ? 'disabled' : ''); ?>">
                  <?php echo e($package->is_sold_out ? 'Epuise' : 'Louer Maintenant'); ?>

                </a>
              </div>
            </div>
          </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <div class="no-more">— Plus rien —</div>
  </main>
  <div class="overlay" id="popupNotice">
    <div class="popup">
      <div class="close-btn" onclick="closePopup()">❌</div>
      <p><span class="emoji">🎁</span><span>R25</span> bonus d'inscription a ete envoye a votre compte et vous pouvez l'utiliser pour un retrait</p>
      <p><span class="emoji">💎</span>Le cycle d'investissement represente le temps de cycle, mais vous pouvez demander un retrait chaque jour</p>
      <p><span class="emoji">🎁</span>L'investissement dans les dispositifs waffarm rapporte entre 35 et 48 jours, representant le temps pour un revenu continu, et vous recevrez un revenu chaque jour, vous pouvez retirer de l'argent chaque jour.</p>
      <p><span class="emoji">🌕</span>Waffarm est l'une des plus grandes entreprises d'elevage et d'agriculture propre au monde</p>
      <p><span class="emoji">🎁</span>Invitez des amis pour obtenir une recompense en argent de 12% du montant du depot de l'ami</p>
      <p><span class="emoji">🏆</span>Le revenu d'investissement peut etre retire quotidiennement</p>
      <p><span class="emoji">💰</span>Retrait instantane sans temps d'attente</p>
      <button onclick="closePopup()">Confirmer</button>
      <a class="join-btn" href="https://chat.whatsapp.com/YOUR_GROUP_LINK_HERE" target="_blank">
        <img src="https://upload.wikimedia.org/wikipedia/commons/6/6b/WhatsApp.svg" alt="Logo WhatsApp">
        Rejoindre le groupe WhatsApp
      </a>
    </div>
  </div>
</div>

<?php echo $__env->make('app.layout.manu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css">
<script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>

<script>
    const swiperContainer = new Swiper('.swiper-container', {

        loop: true, 
        autoplay: {
            delay: 3000, 
            disableOnInteraction: false, 
        },
        pagination: {
            el: '.swiper-pagination', 
            clickable: true, 
        },
    });

    const swiper = new Swiper('.swiper', {
        direction: 'vertical',
        loop: true, 
        autoplay: {
            delay: 3000, 
            disableOnInteraction: false, 
        },
        pagination: {
            el: '.swiper-pagination', 
            clickable: true, 
        },
    });
</script>
<script>
    // Wait for the DOM to fully load
    document.addEventListener("DOMContentLoaded", function () {
        const modal = document.querySelector(".z-mask");
        const confirmBtn = document.querySelector(".maskBtn");

        // Show the modal after 2 seconds
        setTimeout(() => {
            modal.style.display = "block";
        }, 2000);

        // Hide the modal when Confirm is clicked
        confirmBtn.addEventListener("click", function () {
            modal.style.display = "none";
        });
    });
</script>
<script>
  function closePopup() {
    document.getElementById('popupNotice').style.display = 'none';
  }
</script>

  <script>
    function showTab(evt, tabId) {
      document.querySelectorAll('.product-tab').forEach(tab => tab.classList.remove('active'));
      document.querySelectorAll('.tab-buttons button').forEach(btn => btn.classList.remove('active'));
      document.getElementById(tabId).classList.add('active');
      evt.target.classList.add('active');
    }

    function updateCountdowns() {
      const now = new Date();
      document.querySelectorAll('.countdown').forEach(el => {
        const end = new Date(el.getAttribute('data-end'));
        const diff = end - now;
        if (diff > 0) {
          const d = Math.floor(diff / (1000 * 60 * 60 * 24));
          const h = Math.floor((diff / (1000 * 60 * 60)) % 24);
          const m = Math.floor((diff / (1000 * 60)) % 60);
          const s = Math.floor((diff / 1000) % 60);
          el.textContent = `⏳ ${d}d ${h}h ${m}m ${s}s`;
        } else {
          el.textContent = '⏰ Expired';
        }
      });
    }

    setInterval(updateCountdowns, 1000);
    updateCountdowns();
  </script>

  <!-- JS -->
  <script src="https://cdn.jsdelivr.net/npm/layui@2.8.17/dist/layui.js"></script>
  <script>
    layui.use('carousel', function(){
      var carousel = layui.carousel;
      carousel.render({
        elem: '#banner-carousel',
        width: '100%',
        height: '180px',
        interval: 3000,
        anim: 'fade',
        arrow: 'none'
      });
    });
  </script>

</body>
</html>
<?php /**PATH /home/qrdvyvrf/dm3.abb1-egypt.top/resources/views/app/main/index.blade.php ENDPATH**/ ?>