<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0, viewport-fit=cover"/>
    <title>WAF | Mon Compte</title>
    <link rel="stylesheet" href="/static/reset.css"/>
    <link rel="stylesheet" href="/static/style.css"/>
    <link rel="stylesheet" href="/static/layui.css"/>
    <script type="text/javascript" src="/static/layui.js"></script>
    <script type="text/javascript" src="/static/jquery-3.5.1.min.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/layui@2.8.17/dist/css/layui.css" />
    <style>
        :root {
            --green: #55b432;
            --green-dark: #4ca828;
            --gray: #666;
            --bg: #f4f6f9;
        }
        * {
            box-sizing: border-box;
        }
        body {
            margin: 0;
            font-family: 'Segoe UI', sans-serif;
            background: var(--bg);
            padding-bottom: 80px;
            color: #333;
        }
        a {
            color: inherit;
            text-decoration: none;
        }
        .welcome-message {
            position: absolute;
            top: 10px;
            right: 12px;
            background: linear-gradient(to right, var(--green), var(--green-dark));
            color: white;
            padding: 6px 12px;
            font-size: 12px;
            border-radius: 20px;
            animation: pulse 2s infinite;
            box-shadow: 0 0 10px rgba(85, 180, 50, 0.4);
        }
        @keyframes pulse {
            0%, 100% { transform: scale(1); opacity: 0.9; }
            50% { transform: scale(1.05); opacity: 1; }
        }
        .top-bar {
            background: var(--green);
            padding: 16px;
            color: #fff;
            display: flex;
            align-items: center;
            position: relative;
            border-bottom: 3px solid #e6e6e6;
        }
        .top-bar img {
            width: 55px;
            height: 55px;
            border-radius: 50%;
            margin-right: 12px;
            border: 2px solid #fff;
        }
        .user-info .id {
            font-weight: bold;
            font-size: 16px;
        }
        .user-info .phone {
            font-size: 13px;
            opacity: 0.9;
        }
        .quick-actions,
        .more-actions {
            background: #fff;
            margin: 14px;
            border-radius: 16px;
            padding: 12px 0;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
            display: flex;
            justify-content: space-around;
            flex-wrap: wrap;
        }
        .action-item {
            text-align: center;
            width: 33.33%;
            margin: 12px 0;
            transition: transform 0.2s ease;
        }
        .action-item:hover {
            transform: scale(1.05);
        }
        .action-item img {
            width: 40px;
            height: 40px;
            margin-bottom: 6px;
            background: var(--green);
            padding: 6px;
            border-radius: 50%;
        }
        .stats {
            background: #fff;
            margin: 14px;
            border-radius: 16px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
            display: grid;
            grid-template-columns: repeat(2, 1fr);
        }
        .stat-box {
            padding: 16px;
            border-bottom: 1px solid #eee;
            border-right: 1px solid #eee;
            text-align: center;
        }
        .stat-box:nth-child(2n) { border-right: none; }
        .stat-box:nth-last-child(-n+2) { border-bottom: none; }
        .stat-value {
            font-weight: bold;
            font-size: 18px;
            color: var(--green);
        }
        .stat-label {
            font-size: 12px;
            color: var(--gray);
            margin-top: 3px;
        }
        .logout-btn {
            background: linear-gradient(to right, var(--green), var(--green-dark));
            margin: 24px 14px;
            padding: 14px;
            text-align: center;
            border-radius: 30px;
            font-weight: bold;
            color: #fff;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            cursor: pointer;
            transition: all 0.3s ease;
        }
        .logout-btn:hover {
            transform: scale(1.03);
            background: var(--green-dark);
        }
        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            display: flex;
            justify-content: space-around;
            background: #fff;
            border-top: 1px solid #ddd;
            padding: 8px 0;
            box-shadow: 0 -2px 6px rgba(0, 0, 0, 0.05);
        }
        .bottom-nav a {
            text-align: center;
            font-size: 12px;
            color: #999;
            display: flex;
            flex-direction: column;
            align-items: center;
            transition: 0.3s;
        }
        .bottom-nav a img {
            width: 22px;
            margin-bottom: 2px;
        }
        .bottom-nav a.active {
            color: var(--green);
        }
        .bottom-nav a.active img {
            filter: brightness(1.3);
        }
    </style>
</head>
<body>
    <div class="top-bar">
        <img src="<?php echo e(asset('public')); ?>/static/img/logo1.png" alt="Utilisateur" />
        <div class="user-info">
            <div class="id">ID: <?php echo e(auth()->user()->ref_id); ?></div>
            <div class="phone">Compte: <?php echo e(auth()->user()->phone); ?></div>
        </div>
        <div class="welcome-message">Bienvenue, <?php echo e(auth()->user()->name ?? 'Utilisateur'); ?></div>
    </div>
    <div style="margin-top: 20px; height: 100px;">
        <a href="/my-team">
            <img style="height: 100px" src="/public/images/invite.png" alt="">
        </a>
    </div>
    <div class="my-income-link">
        <a onclick="window.location.href='<?php echo e(route('user.deposit')); ?>'">
            <img src="/public/images/profile/m_2.png" alt="">Recharge
        </a>
        <a href="/withdraw">
            <img src="/public/images/profile/m_1.png" alt="">Retrait
        </a>
    </div>

<?php
    $walletTotal =
        (auth()->user()->balance ?? 0) +
        (auth()->user()->deposit_wallet ?? 0) +
        (auth()->user()->today_income ?? 0) +
        (auth()->user()->team_income ?? 0) +
        (auth()->user()->total_income ?? 0);
?>
    <div class="stats">
        <div class="stat-box">
            <div class="stat-value" data-count="<?php echo e((auth()->user()->balance)); ?>"><?php echo e((auth()->user()->balance)); ?></div>
            <div class="stat-label">Portefeuille de Retrait</div>
        </div>
        <div class="stat-box">
            <div class="stat-value" data-count=" <?php echo e((auth()->user()->deposit_wallet)); ?>"> <?php echo e((auth()->user()->deposit_wallet)); ?></div>
            <div class="stat-label">Portefeuille de Recharge</div>
        </div>
        <div class="stat-box">
            <div class="stat-value" data-count=" <?php echo e((auth()->user()->today_income)); ?>"> <?php echo e((auth()->user()->today_income)); ?></div>
            <div class="stat-label">Revenu d'Aujourd'hui</div>
        </div>
        <div class="stat-box">
            <div class="stat-value" data-count="<?php echo e(($walletTotal)); ?>"><?php echo e(($walletTotal)); ?></div>
            <div class="stat-label">Actifs</div>
        </div>
        <div class="stat-box">
            <div class="stat-value" data-count=" <?php echo e((auth()->user()->team_income)); ?>"> <?php echo e((auth()->user()->team_income)); ?></div>
            <div class="stat-label">Revenu d'Aquipe</div>
        </div>
        <div class="stat-box">
            <div class="stat-value" data-count="<?php echo e((auth()->user()->total_income)); ?>"><?php echo e((auth()->user()->total_income)); ?></div>
            <div class="stat-label">Revenu Total</div>
        </div>
    </div>
    <div class="my-top-nav">
        <ul>
            <li>
                <a href="/ordered">
                    <img src="/public/images/profile/m_5.png" alt="">
                    <p>Mon Produit</p>
                </a>
            </li>
            <li>
                <a href="/add-bank">
                    <img src="/public/images/profile/m_3.png" alt="">
                    <p>Lier Compte</p>
                </a>
            </li>
            <li>
                <a href="/spin">
                    <img src="/public/images/profile/m_4.png" alt="">
                    <p>Code Bonus</p>
                </a>
            </li>
            <li>
                <a href="/history">
                    <img src="/public/images/profile/m_6.png" alt="">
                    <p>Historique des Transactions</p>
                </a>
            </li>
            <li>
                <a href="/change/password">
                    <img src="/public/images/profile/m_7.png" alt="">
                    <p>Mot de Passe</p>
                </a>
            </li>
            <li>
                <a href="/reward">
                    <img src="/public/images/profile/reward.png" alt="">
                    <p>Salaire</p>
                </a>
            </li>
        </ul>
    </div>
    <div class="logout-btn">
        <a href="/logout">Se Déconnecter</a>
    </div>
    <?php echo $__env->make('app.layout.manu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script>
        // Animation des nombres
        const counters = document.querySelectorAll('.stat-value');
        counters.forEach(counter => {
            let target = parseFloat(counter.getAttribute('data-count'));
            let count = 0;
            let step = target / 40;
            let interval = setInterval(() => {
                count += step;
                if (count >= target) {
                    count = target;
                    clearInterval(interval);
                }
                counter.innerText = 'F' + count.toFixed(2);
            }, 30);
        });
        // Optionnel: alerte de bienvenue
        setTimeout(() => {
            //alert("🎉 Bienvenue sur votre tableau de bord !");
        }, 1000);
    </script>
</body>
</html>
<?php /**PATH /home/qrdvyvrf/dm3.abb1-egypt.top/resources/views/app/main/profile.blade.php ENDPATH**/ ?>