<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0, viewport-fit=cover"/>
    <title>Équipe</title>
    <link rel="stylesheet" href="/static/reset.css"/>
    <link rel="stylesheet" href="/static/style.css"/>
    <link rel="stylesheet" href="/static/layui.css"/>
    <script type="text/javascript" src="/static/layui.js"></script>
    <script type="text/javascript" src="/static/jquery-3.5.1.min.js"></script>
    <style>
        .team-section { display: none; }
        .team-section.active { display: block; }
        .inline-tab .cur { font-weight: bold; }
    </style>
    <style>
        /* Ajouter des styles pour le message de chargement */
        .loading-message {
            display: none; /* Masqué par défaut */
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            background-color: white;
            border: 1px solid #ccc;
            padding: 20px;
            z-index: 1000;
            text-align: center;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }
    </style>
</head>
<body class="homeColor">
<div class="top">
    <a href="/profile" class="topLeft">
        <i class="layui-icon layui-icon-left"></i>
    </a>
    <div class="topTit">Mon Équipe</div>
</div>
<div class="team-main">
    <div class="team-totalNum">
        <dl>
            <dt>Revenu Total</dt>
            <dd><?php echo e(price(auth()->user()->team_income)); ?></dd>
        </dl>
        <dl>
            <dt>Total des Invitations</dt>
            <dd><?php echo e($team_size); ?></dd>
        </dl>
    </div>
    <div class="team-code">
        <div class="team-code-item">
            <div class="code-tit">Code d'Invitation</div>
            <div class="team-code-copy" data-clipboard-text="<?php echo e(auth()->user()->ref_id); ?>">
                <div class="team-code-input"><?php echo e(auth()->user()->ref_id); ?></div>
                <div class="copy" onclick="copyCode(this)">COPIER</div>
            </div>
        </div>
        <?php
            $referralLink = url('register') . '?ref=' . auth()->user()->ref_id;
        ?>
        <div class="team-code-item">
            <div class="team-code-left">
                <div class="code-tit">Lien d'Invitation</div>
                <div class="team-code-copy" data-clipboard-text="<?php echo e($referralLink); ?>">
                    <div class="team-code-input"><?php echo e($referralLink); ?></div>
                    <div class="copy" onclick="copyCode(this)">COPIER</div>
                </div>
            </div>
        </div>
    </div>
    <?php
        // Récupérer les valeurs de rabais pour chaque niveau d'équipe
        $rebate1 = \App\Models\Rebate::sum('interest_commission1');
        $rebate2 = \App\Models\Rebate::sum('interest_commission2');
        $rebate3 = \App\Models\Rebate::sum('interest_commission3');
    ?>
    <div class="team-record">
        <div class="inline-tab">
            <a href="#" class="tab cur" data-team="teamB" onclick="showTeam('teamB')">Équipe A<i></i></a>
            <a href="#" class="tab" data-team="teamC" onclick="showTeam('teamC')">Équipe B<i></i></a>
            <a href="#" class="tab" data-team="teamD" onclick="showTeam('teamD')">Équipe C<i></i></a>
        </div>
        <div id="teamB-summary" class="team-summary active">
            <ul>
                <li><h3><?php echo e($first_level_users->count()); ?></h3><p>Total des Invitations</p></li>
                <li><h3><?php echo e($first_level_users->where('investor', 1)->count()); ?></h3><p>Invitations Valides</p></li>
                <li><h3><?php echo e(price($levelTotalCommission1)); ?></h3><p>Revenu Total</p></li>
                <li><h3><?php echo e($rebate1); ?></h3><p>Profit de l'Équipe</p></li>
            </ul>
        </div>
        <div id="teamC-summary" class="team-summary">
            <ul>
                <li><h3><?php echo e($second_level_users->count()); ?></h3><p>Total des Invitations</p></li>
                <li><h3><?php echo e($second_level_users->where('investor', 1)->count()); ?></h3><p>Invitations Valides</p></li>
                <li><h3><?php echo e(price($levelTotalCommission2)); ?></h3><p>Revenu Total</p></li>
                <li><h3><?php echo e($rebate2); ?></h3><p>Profit de l'Équipe</p></li>
            </ul>
        </div>
        <div id="teamD-summary" class="team-summary">
            <ul>
                <li><h3><?php echo e($third_level_users->count()); ?></h3><p>Total des Invitations</p></li>
                <li><h3><?php echo e($third_level_users->where('investor', 1)->count()); ?></h3><p>Invitations Valides</p></li>
                <li><h3><?php echo e(price($levelTotalCommission3)); ?></h3><p>Revenu Total</p></li>
                <li><h3><?php echo e($rebate3); ?></h3><p>Profit de l'Équipe</p></li>
            </ul>
        </div>
    </div>
    <div class="teamList">
        <table>
            <thead>
                <tr>
                    <td>Mobile</td>
                    <td>Niveau</td>
                    <td>Investissement</td>
                </tr>
            </thead>
            <!-- Utilisateurs de Premier Niveau -->
            <tbody id="teamB" class="team-users active">
                <?php $__currentLoopData = $first_level_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($user->phone); ?></td>
                        <td>A</td>
                        <td><?php echo e(price($user->purchases->sum('amount') ?? 0)); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
            <!-- Utilisateurs de Deuxième Niveau -->
            <tbody id="teamC" class="team-users">
                <?php $__currentLoopData = $second_level_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($user->phone); ?></td>
                        <td>B</td>
                        <td><?php echo e(price($user->purchases->sum('amount') ?? 0)); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
            <!-- Utilisateurs de Troisième Niveau -->
            <tbody id="teamD" class="team-users">
                <?php $__currentLoopData = $third_level_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($user->phone); ?></td>
                        <td>C</td>
                        <td><?php echo e(price($user->purchases->sum('amount') ?? 0)); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
    <?php echo $__env->make('app.layout.manu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <style>
        .team-summary, .team-users {
            display: none;
        }
        .team-summary.active, .team-users.active {
            display: block;
        }
    </style>
    <div id="loading-message" class="loading-message">Succès...</div>
    <script>
        function showTeam(team) {
            document.querySelectorAll('.tab').forEach(tab => tab.classList.remove('cur'));
            document.querySelectorAll('.team-summary, .team-users').forEach(section => section.classList.remove('active'));
            document.querySelector(`.tab[data-team="${team}"]`).classList.add('cur');
            document.getElementById(`${team}-summary`).classList.add('active');
            document.getElementById(team).classList.add('active');
        }

        function copyCode(element) {
            const textToCopy = element.parentElement.getAttribute('data-clipboard-text');
            navigator.clipboard.writeText(textToCopy).then(() => {
                // Afficher le message de chargement pour le succès
                const loadingMessage = document.getElementById('loading-message');
                loadingMessage.style.display = 'block';

                // Masquer le message après 1,5 seconde
                setTimeout(() => {
                    loadingMessage.style.display = 'none';
                }, 1500);
            }).catch(err => {
                console.error('Échec de la copie du texte: ', err);
            });
        }
    </script>
</body>
</html>
<?php /**PATH /home/qrdvyvrf/dm3.abb1-egypt.top/resources/views/app/main/team/index.blade.php ENDPATH**/ ?>