<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Menu Pied de Page</title>
  <style>
    .footer_menu {
      position: fixed;
      z-index: 9999;
      bottom: 0;
      left: 0;
      right: 0;
      border-radius: 120px 120px 0 0;
      margin: 0;
      padding: 0;
    }
    .footer_menu .content {
      background: #fff;
      display: flex;
      width: 100%;
      color: #A1BFF6;
    }
    .footer_menu .item {
      flex: 1;
      text-align: center;
      padding: 10px 0;
      transition: background-color 0.3s ease;
    }
    .footer_menu .item img {
      position: relative;
      width: 21px;
      height: 21px;
      transition: all 0.3s ease;
      filter: grayscale(100%);
    }
    .footer_menu .item p {
      margin-top: 4px;
      font-family: Arial, sans-serif;
      font-size: 14px;
      color: #AFAFAF;
      line-height: 20px;
      transition: color 0.3s ease;
    }
    .footer_menu .active p {
      color: #55b432;
    }
    .footer_menu .active img {
      filter: grayscale(0%);
      mix-blend-mode: multiply;
      background-color: #55b432;
      border-radius: 50%;
      padding: 2px;
    }
  </style>
</head>
<body>
  <!-- Section Pied de Page -->
  <div class="footer_menu">
    <div class="content">
      <a href="/home" class="item" id="home-link">
        <img src="/public/site/img/footer/home.png" alt="Accueil">
        <p>Accueil</p>
      </a>
      <a href="/products" class="item" id="product-link">
        <img src="/public/site/img/footer/product (1).png" alt="Produits">
        <p>Produits</p>
      </a>
      <a href="/my-team" class="item" id="notice-link">
        <img src="/public/site/img/footer/team.png" alt="Équipe">
        <p>Equipe</p>
      </a>
      <a href="/profile" class="item" id="account-link">
        <img src="/public/site/img/footer/mine.png" alt="Mon Compte">
        <p>Mon Compte</p>
      </a>
    </div>
  </div>
  <script>
    const currentPath = window.location.pathname;
    const footerItems = document.querySelectorAll('.footer_menu .item');
    footerItems.forEach(item => item.classList.remove('active'));
    if (currentPath.startsWith('/home')) {
      document.getElementById('home-link').classList.add('active');
    } else if (currentPath.startsWith('/products')) {
      document.getElementById('product-link').classList.add('active');
    } else if (currentPath.startsWith('/my-team')) {
      document.getElementById('notice-link').classList.add('active');
    } else if (currentPath.startsWith('/profile')) {
      document.getElementById('account-link').classList.add('active');
    }
    footerItems.forEach(item => {
      item.addEventListener('click', () => {
        footerItems.forEach(i => i.classList.remove('active'));
        item.classList.add('active');
      });
    });
  </script>
</body>
</html>
<?php /**PATH /home/qrdvyvrf/dm3.abb1-egypt.top/resources/views/app/layout/manu.blade.php ENDPATH**/ ?>