<?php $__env->startSection('admin_content'); ?>
    <section id="dashboard-ecommerce">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0">
                        <h4 class="card-title">
                            <div class="d-flex justify-content-between">
                                <div><?php echo e($title); ?> Withdraw Lists</div>
                            </div>
                        </h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <div class="table-responsive">
                                <table class="table table-striped dataex-html5-selectors">
                                    <thead>
                                    <tr>
                                        <th>S.N</th>
                                        <th>User</th>
                                        <th>Channel</th>
                                        <th>Address</th>
                                        <th>Amount</th>
                                        <th>Status</th>
                                        <th>Active</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $withdraws; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($key + 1); ?></td>
                                            <td>
                                                <small>
                                                    Phone: <?php echo e($row->user->phone ?? '--'); ?>  <br>
                                                    Ref id: <?php echo e($row->user->ref_id ?? '--'); ?> <br>
                                                </small>
                                            </td>
                                            <td>
                                                <?php echo e($row->payment_method); ?>

                                            </td>
                                            <td width="100">
                                                <div style="width: 100px;overflow: hidden">
                                                    <?php echo e($row->number ?? '---'); ?>

                                                    <a href="javascript:void(0)" onclick="copyLink('<?php echo e($row->number); ?>')" class="btn btn-sm btn-primary">Copy</a>
                                                </div>
                                            </td>
                                            <td>
                                                <small>
                                                    Withdraw Amount: <?php echo e(price($row->amount)); ?> <br>
                                                    Withdraw Charge: <?php echo e(price($row->charge)); ?> <br>
                                                    Final Amount : <?php echo e(price($row->final_amount)); ?>

                                                </small>
                                            </td>
                                            <td>
                                                <span class="badge <?php if($row->status == 'pending'): ?> badge-warning <?php elseif($row->status == 'approved'): ?> badge-success  <?php elseif($row->status == 'rejected'): ?> badge-danger <?php endif; ?>" style="font-size: 8px"><?php echo e($row->status); ?></span>
                                            </td>
                                            <td>
                                                <?php if($row->status == 'pending'): ?>
                                                    <a href="javascript:void(0)" data-toggle="modal" data-target="#myModal<?php echo e($row->id); ?>" class="btn btn-success">Action</a>
                                                    <form action="<?php echo e(route('withdraw.status.change', $row->id)); ?>" method="POST"><?php echo csrf_field(); ?>
                                                        <div class="modal fade" id="myModal<?php echo e($row->id); ?>">
                                                            <div class="modal-dialog">
                                                                <div class="modal-content">

                                                                    <!-- Modal Header -->
                                                                    <div class="modal-header">
                                                                        <h4 class="modal-title">Action for withdraw</h4>
                                                                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                                    </div>

                                                                    <!-- Modal body -->
                                                                    <div class="modal-body">
                                                                        <div class="form-group">
                                                                            <label for="status">Status <small class="text-info"> You can change withdraw status link approved, rejected, pending is default </small> </label>
                                                                            <select name="status" required id="status" class="form-control">
                                                                                <option value="approved" <?php if($row->status == 'approved'): ?> selected <?php endif; ?>>Approved</option>
                                                                                <option value="rejected" <?php if($row->status == 'rejected'): ?> selected <?php endif; ?>>Rejected</option>
                                                                                <option value="pending" <?php if($row->status == 'pending'): ?> selected <?php endif; ?>>Pending</option>
                                                                            </select>
                                                                        </div>

                                                                        <div class="form-group">
                                                                            <label for="transfer_type">Payout Type <small class="text-info"> This action works if status you selected as Approved </small> </label>
                                                                            <select name="transfer_type" required id="transfer_type" class="form-control">
                                                                                <option value="auto" <?php if($row->status == 'approved'): ?> selected <?php endif; ?>>Automatic (Via <?php echo e(strtoupper($setting->auto_transfer_default)); ?>)</option>
                                                                                <option value="manual" <?php if($row->status == 'rejected'): ?> selected <?php endif; ?>>Manual</option>
                                                                            </select>
                                                                        </div>

                                                                    </div>

                                                                    <!-- Modal footer -->
                                                                    <div class="modal-footer">
                                                                        <input type="submit" value="Submit" class="btn btn-primary">
                                                                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                                                    </div>

                                                                </div>
                                                            </div>
                                                        </div>
                                                    </form>
                                                <?php else: ?>
                                                    <div class="text-info">Already push a action</div>
                                                <?php endif; ?>

                                                    <a href="<?php echo e(route('admin.customer.login', $row->id)); ?>"
                                                       target="_blank"
                                                       class="btn btn-info"
                                                       style="padding: 3px 7px;font-size: 20px"
                                                       data-toggle="tooltip" title='Login Into User Account'>
                                                        <i class="bx bx-user"></i></a>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script>
        function copyLink(text)
        {
            const body = document.body;
            const input = document.createElement("input");
            body.append(input);
            input.style.opacity = 0;
            input.value = text.replaceAll(' ', '');
            input.select();
            input.setSelectionRange(0, input.value.length);
            document.execCommand("Copy");
            input.blur();
            input.remove();
            message('Copied success..')
        }
    </script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('admin.partials.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/qrdvyvrf/dm3.abb1-egypt.top/resources/views/admin/pages/withdraw/list.blade.php ENDPATH**/ ?>